"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConfirmDeleteModal extends _react.Component {
  renderJobs() {
    const {
      jobs
    } = this.props;
    const jobItems = jobs.map(({
      id,
      status
    }) => {
      const startedMessage = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.startedMessage', {
        defaultMessage: 'started'
      });
      const statusText = status === 'started' ? ` (${startedMessage})` : null;
      return /*#__PURE__*/_react.default.createElement("li", {
        key: id
      }, id, statusText);
    });
    return /*#__PURE__*/_react.default.createElement("ul", null, jobItems);
  }
  render() {
    const {
      isSingleSelection,
      jobs,
      onCancel,
      onConfirm
    } = this.props;
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    let title;
    let content;
    if (isSingleSelection) {
      const {
        id,
        status
      } = jobs[0];
      title = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.deleteSingleJobTitle', {
        defaultMessage: "Delete rollup job ''{id}''?",
        values: {
          id
        }
      });
      if (status === 'started') {
        content = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.deleteSingleJobDescription",
          defaultMessage: "This job has been started."
        }));
      }
    } else {
      title = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.multipleDeletionTitle', {
        defaultMessage: 'Delete {count} rollup jobs?',
        values: {
          count: jobs.length
        }
      });
      content = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.multipleDeletionDescription",
        defaultMessage: "You are about to delete {isSingleSelection, plural, one {this job} other {these jobs}}",
        values: {
          isSingleSelection: isSingleSelection ? 1 : 0
        }
      })), this.renderJobs());
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      title: title,
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: onCancel,
      onConfirm: onConfirm,
      cancelButtonText: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.cancelButtonText', {
        defaultMessage: 'Cancel'
      }),
      buttonColor: "danger",
      confirmButtonText: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.confirmButtonText', {
        defaultMessage: 'Delete'
      })
    }, content);
  }
}
exports.ConfirmDeleteModal = ConfirmDeleteModal;
(0, _defineProperty2.default)(ConfirmDeleteModal, "propTypes", {
  isSingleSelection: _propTypes.default.bool.isRequired,
  jobs: _propTypes.default.array.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  onConfirm: _propTypes.default.func.isRequired
});