"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportingPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingPublic = require("@kbn/reporting-public");
var _share = require("@kbn/reporting-public/share");
var _reportingCsvSharePanel = require("@kbn/reporting-csv-share-panel");
var _stream_handler = require("./lib/stream_handler");
var _translations = require("./translations");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * @internal
 * @implements Plugin
 */
class ReportingPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "apiClient", void 0);
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "title", _i18n.i18n.translate('xpack.reporting.management.reportingTitle', {
      defaultMessage: 'Reporting'
    }));
    (0, _defineProperty2.default)(this, "breadcrumbText", _i18n.i18n.translate('xpack.reporting.breadcrumb', {
      defaultMessage: 'Reporting'
    }));
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "contract", void 0);
    (0, _defineProperty2.default)(this, "startServices$", void 0);
    this.config = initializerContext.config.get();
    this.kibanaVersion = initializerContext.env.packageInfo.version;
  }
  getContract(apiClient, startServices$) {
    this.contract = {
      components: (0, _share.getSharedComponents)(apiClient, startServices$)
    };
    if (!this.contract) {
      throw new Error(`Setup error in Reporting plugin!`);
    }
    return this.contract;
  }
  setup(core, setupDeps) {
    const {
      getStartServices
    } = core;
    const {
      home: homeSetup,
      management: managementSetup,
      screenshotMode: screenshotModeSetup,
      share: shareSetup,
      uiActions: uiActionsSetup,
      actions: actionsSetup
    } = setupDeps;
    const startServices$ = (0, _rxjs.from)(getStartServices()).pipe((0, _rxjs.map)(([start, ...rest]) => {
      return [{
        application: start.application,
        notifications: start.notifications,
        rendering: start.rendering,
        uiSettings: start.uiSettings,
        chrome: start.chrome
      }, ...rest];
    }));
    const apiClient = new _reportingPublic.ReportingAPIClient(core.http, core.uiSettings, this.kibanaVersion);
    this.apiClient = apiClient;
    homeSetup.featureCatalogue.register({
      id: 'reporting',
      title: _translations.APP_TITLE,
      description: _translations.APP_DESC,
      icon: 'reportingApp',
      path: _constants.APP_PATH,
      showOnHomePage: false,
      category: 'admin'
    });
    managementSetup.sections.section.insightsAndAlerting.registerApp({
      id: 'reporting',
      title: this.title,
      order: 3,
      keywords: ['reports', 'report', 'reporting'],
      mount: async params => {
        params.setBreadcrumbs([{
          text: this.breadcrumbText
        }]);
        const [[coreStart, startDeps], {
          mountManagementSection
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./management/mount_management_section')))]);
        const {
          licensing,
          data,
          share
        } = startDeps;
        const {
          docTitle
        } = coreStart.chrome;
        docTitle.change(this.title);
        const umountAppCallback = await mountManagementSection({
          coreStart,
          license$: licensing.license$,
          dataService: data,
          shareService: share,
          config: this.config,
          apiClient,
          params,
          actionsService: actionsSetup,
          notificationsService: coreStart.notifications
        });
        return () => {
          docTitle.reset();
          umountAppCallback();
        };
      }
    });
    core.application.register({
      id: 'reportingRedirect',
      mount: async params => {
        const [startServices, importParams] = await Promise.all([core.getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./redirect')))]);
        const [coreStart] = startServices;
        const {
          mountRedirectApp
        } = importParams;
        return mountRedirectApp(coreStart, {
          ...params,
          apiClient,
          screenshotMode: screenshotModeSetup,
          share: shareSetup
        });
      },
      title: 'Reporting redirect app',
      chromeless: true,
      exactRoute: true,
      visibleIn: []
    });
    uiActionsSetup.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, new _reportingCsvSharePanel.ReportingCsvPanelAction({
      core,
      apiClient,
      startServices$,
      csvConfig: this.config.csv
    }));
    shareSetup.registerShareIntegration('search',
    // TODO: export the reporting pdf export provider for registration in the actual plugins that depend on it
    (0, _share.reportingCsvExportShareIntegration)({
      apiClient,
      startServices$
    }));
    if (this.config.export_types.pdf.enabled || this.config.export_types.png.enabled) {
      shareSetup.registerShareIntegration(
      // TODO: export the reporting pdf export provider for registration in the actual plugins that depend on it
      (0, _share.reportingPDFExportShareIntegration)({
        apiClient,
        startServices$
      }));
      shareSetup.registerShareIntegration(
      // TODO: export the reporting pdf export provider for registration in the actual plugins that depend on it
      (0, _share.reportingPNGExportShareIntegration)({
        apiClient,
        startServices$
      }));
    }
    Promise.resolve().then(() => _interopRequireWildcard(require('./management/integrations/scheduled_report_share_integration'))).then(async ({
      shouldRegisterScheduledReportShareIntegration,
      createScheduledReportShareIntegration
    }) => {
      const [coreStart, startDeps] = await getStartServices();
      if (await shouldRegisterScheduledReportShareIntegration(core.http)) {
        shareSetup.registerShareIntegration(createScheduledReportShareIntegration({
          apiClient,
          services: {
            ...coreStart,
            ...startDeps,
            actions: actionsSetup
          }
        }));
      }
    });
    this.startServices$ = startServices$;
    return this.getContract(apiClient, startServices$);
  }
  start(core) {
    const streamHandler = new _stream_handler.ReportingNotifierStreamHandler(this.apiClient, core);
    const interval = (0, _reportingCommon.durationToNumber)(this.config.poll.jobsRefresh.interval);
    streamHandler.startPolling(interval, this.stop$);
    return this.getContract(this.apiClient, this.startServices$);
  }
  stop() {
    this.stop$.next();
  }
}
exports.ReportingPublicPlugin = ReportingPublicPlugin;