"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reportingPublic = require("@kbn/reporting-public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const title = /*#__PURE__*/_react.default.createElement("h2", {
  "data-test-subj": "license-prompt-title"
}, _i18n.i18n.translate('xpack.reporting.schedules.licenseCheck.title', {
  defaultMessage: `Upgrade your license to use Scheduled Exports`
}));
const LicensePrompt = exports.LicensePrompt = /*#__PURE__*/_react.default.memo(() => {
  const {
    application
  } = (0, _reportingPublic.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    "data-test-subj": "schedules-license-prompt",
    title: title,
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": "license-prompt-upgrade",
      key: "upgrade-subscription-button",
      target: "_blank",
      href: "https://www.elastic.co/subscriptions"
    }, _i18n.i18n.translate('xpack.reporting.schedules.licenseCheck.upgrade', {
      defaultMessage: `Upgrade`
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "license-prompt-trial",
      key: "start-trial-button",
      target: "_blank",
      href: application.getUrlForApp('management', {
        path: 'stack/license_management/home'
      })
    }, _i18n.i18n.translate('xpack.reporting.schedules.licenseCheck.startTrial', {
      defaultMessage: `Start a trial`
    }))))))
  });
});
LicensePrompt.displayName = 'LicensePrompt';