"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadClusters = void 0;
var _services = require("../../services");
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadClusters = () => async dispatch => {
  dispatch({
    type: _action_types.LOAD_CLUSTERS_START
  });
  let clusters;
  try {
    clusters = await (0, _services.loadClusters)();
  } catch (error) {
    return dispatch({
      type: _action_types.LOAD_CLUSTERS_FAILURE,
      payload: {
        error
      }
    });
  }
  dispatch({
    type: _action_types.LOAD_CLUSTERS_SUCCESS,
    payload: {
      clusters
    }
  });
};
exports.loadClusters = loadClusters;