"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateName = validateName;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateName(name) {
  if (!name || !name.trim()) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.form.errors.nameMissing",
      defaultMessage: "Name is required."
    });
  }
  if (name.includes(' ')) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.form.errors.illegalSpace",
      defaultMessage: "Spaces are not allowed in the name."
    });
  }
  const illegalCharacters = name.match(/[^a-zA-Z\d\-_]/g);
  if (illegalCharacters) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.form.errors.illegalCharacters",
      defaultMessage: "Remove the {characterListLength, plural, one {character} other {characters}} {characterList} from the name.",
      values: {
        characterList: /*#__PURE__*/_react.default.createElement("strong", null, illegalCharacters.join(' ')),
        characterListLength: illegalCharacters.length
      }
    });
  }
  return null;
}