"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KIBANA_SOLUTIONS = exports.KIBANA_SECURITY_SOLUTION = exports.KIBANA_SECURITY_PROJECT = exports.KIBANA_SEARCH_SOLUTION = exports.KIBANA_SEARCH_PROJECT = exports.KIBANA_PROJECTS = exports.KIBANA_PLATFORM = exports.KIBANA_OBSERVABILITY_SOLUTION = exports.KIBANA_OBSERVABILITY_PROJECT = exports.KIBANA_GROUPS = exports.KIBANA_CHAT_SOLUTION = exports.KIBANA_CHAT_PROJECT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The base group, for all modules that are commonly used across solutions.
 */
const KIBANA_PLATFORM = exports.KIBANA_PLATFORM = 'platform';
/**
 * Constant for the Kibana Observability solution.
 */
const KIBANA_OBSERVABILITY_SOLUTION = exports.KIBANA_OBSERVABILITY_SOLUTION = 'observability';
/**
 * Constant for the Kibana Security solution.
 */
const KIBANA_SECURITY_SOLUTION = exports.KIBANA_SECURITY_SOLUTION = 'security';
/**
 * Constant for the Kibana Search solution.
 */
const KIBANA_SEARCH_SOLUTION = exports.KIBANA_SEARCH_SOLUTION = 'search';
/**
 * Constant for the Kibana Chat (workchat) solution.
 */
const KIBANA_CHAT_SOLUTION = exports.KIBANA_CHAT_SOLUTION = 'chat';

/**
 * A list of all Kibana solutions.
 */
const KIBANA_SOLUTIONS = exports.KIBANA_SOLUTIONS = [KIBANA_OBSERVABILITY_SOLUTION, KIBANA_SECURITY_SOLUTION, KIBANA_SEARCH_SOLUTION, KIBANA_CHAT_SOLUTION]; // BOOKMARK - List of Kibana solutions

/**
 * A type that defines the existing solutions.
 */

/**
 * A list of all Kibana groups (platform + solutions).
 */
const KIBANA_GROUPS = exports.KIBANA_GROUPS = [KIBANA_PLATFORM, ...KIBANA_SOLUTIONS];

/**
 * A type that defines the existing groups (platform + solutions).
 */

/**
 * The groups to which a module can belong.
 * 'common' is the default for uncategorised modules.
 */

/**
 * ModuleVisibility tells whether a module is accessible from any module (shared) or only from modules of the same group (private)
 */

/**
 * Constant for the Kibana Observability (workchat) serverless project type.
 */
const KIBANA_OBSERVABILITY_PROJECT = exports.KIBANA_OBSERVABILITY_PROJECT = 'oblt';
/**
 * Constant for the Kibana Security (workchat) serverless project type.
 */
const KIBANA_SECURITY_PROJECT = exports.KIBANA_SECURITY_PROJECT = 'security';
/**
 * Constant for the Kibana Search (workchat) serverless project type.
 */
const KIBANA_SEARCH_PROJECT = exports.KIBANA_SEARCH_PROJECT = 'es';
/**
 * Constant for the Kibana Chat (workchat) serverless project type.
 */
const KIBANA_CHAT_PROJECT = exports.KIBANA_CHAT_PROJECT = 'chat';

/**
 * A list of all Kibana serverless project types.
 */
const KIBANA_PROJECTS = exports.KIBANA_PROJECTS = [KIBANA_OBSERVABILITY_PROJECT, KIBANA_SECURITY_PROJECT, KIBANA_SEARCH_PROJECT, KIBANA_CHAT_PROJECT]; // BOOKMARK - List of Kibana project types

/**
 * A type that defines the existing serverless project types.
 */