"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DistinctProbabilisticValuesWarning = DistinctProbabilisticValuesWarning;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DistinctProbabilisticValuesWarning({
  totalNumberOfDistinctProbabilisticValues
}) {
  const {
    docLinks
  } = (0, _use_profiling_dependencies.useProfilingDependencies)().start.core;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.profiling.storageExplorer.distinctProbabilisticProfilingValues.title', {
      defaultMessage: "We've identified {count} distinct probabilistic profiling values. Make sure to update them.",
      values: {
        count: totalNumberOfDistinctProbabilisticValues
      }
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.distinctProbabilisticProfilingValues.description', {
    defaultMessage: 'We recommend using a consistent probabilistic value for each project for more efficient storage, cost management, and to maintain good statistical accuracy.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "profilingDistinctProbabilisticValuesWarningLearnHowButton",
    href: `${docLinks.ELASTIC_WEBSITE_URL}/guide/en/observability/${docLinks.DOC_LINK_VERSION}/profiling-probabilistic-profiling.html`,
    color: "warning",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.distinctProbabilisticProfilingValues.button', {
    defaultMessage: 'Learn how'
  })));
}