"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asDuration = asDuration;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

_moment.default.relativeTimeRounding(t => {
  const DIGITS = 2; // like: 2.56 minutes
  return Math.round(t * Math.pow(10, DIGITS)) / Math.pow(10, DIGITS);
});
_moment.default.relativeTimeThreshold('y', 365);
_moment.default.relativeTimeThreshold('M', 12);
_moment.default.relativeTimeThreshold('w', 4);
_moment.default.relativeTimeThreshold('d', 31);
_moment.default.relativeTimeThreshold('h', 24);
_moment.default.relativeTimeThreshold('m', 60);
_moment.default.relativeTimeThreshold('s', 60);
_moment.default.relativeTimeThreshold('ss', 0);
function asDuration(valueInSeconds) {
  if (valueInSeconds === 0) {
    return _i18n.i18n.translate('xpack.profiling.zeroSeconds', {
      defaultMessage: '0 seconds'
    });
  }
  return _moment.default.duration(valueInSeconds * 1000).humanize();
}