"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RouterErrorBoundary = RouterErrorBoundary;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _sharedUxPromptNotFound = require("@kbn/shared-ux-prompt-not-found");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RouterErrorBoundary({
  children
}) {
  const location = (0, _reactRouterDom.useLocation)();
  return /*#__PURE__*/_react.default.createElement(ErrorBoundary, {
    key: location.pathname
  }, children);
}
class ErrorBoundary extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      error: undefined
    });
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  render() {
    if (this.state.error) {
      return /*#__PURE__*/_react.default.createElement(ErrorWithTemplate, {
        error: this.state.error
      });
    }
    return this.props.children;
  }
}
const pageHeader = {
  pageTitle: _i18n.i18n.translate('xpack.profiling.universalProfiling', {
    defaultMessage: 'Universal Profiling'
  })
};
function ErrorWithTemplate({
  error
}) {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    observabilityShared
  } = services;
  const ObservabilityPageTemplate = observabilityShared.navigation.PageTemplate;
  if (error instanceof _typedReactRouterConfig.NotFoundRouteException) {
    return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
      pageHeader: pageHeader
    }, /*#__PURE__*/_react.default.createElement(_sharedUxPromptNotFound.NotFoundPrompt, null));
  }
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: pageHeader
  }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, null, /*#__PURE__*/_react.default.createElement(DummyComponent, {
    error: error
  })));
}
function DummyComponent({
  error
}) {
  throw error;
}