"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CPUStat = CPUStat;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _label = require("./label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CPUStat({
  cpu,
  diffCPU
}) {
  const cpuLabel = `${cpu.toFixed(2)}%`;
  if (diffCPU === undefined || diffCPU === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cpuLabel);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, cpuLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_label.Label, {
    value: diffCPU,
    prepend: "(",
    append: ")"
  })));
}