"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewResultsInLensAction = exports.ViewResultsInDiscoverAction = exports.ViewResultsActionButtonType = exports.PackQueriesStatusTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _constants = require("@kbn/lens-plugin/common/constants");
var _esQuery = require("@kbn/es-query");
var _remove_multilines = require("../../common/utils/build_query/remove_multilines");
var _kibana = require("../common/lib/kibana");
var _scheduled_query_errors_table = require("./scheduled_query_errors_table");
var _use_pack_query_last_results = require("./use_pack_query_last_results");
var _use_pack_query_errors = require("./use_pack_query_errors");
var _use_logs_data_view = require("../common/hooks/use_logs_data_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VIEW_IN_DISCOVER = _i18n.i18n.translate('xpack.osquery.pack.queriesTable.viewDiscoverResultsActionAriaLabel', {
  defaultMessage: 'View in Discover'
});
const VIEW_IN_LENS = _i18n.i18n.translate('xpack.osquery.pack.queriesTable.viewLensResultsActionAriaLabel', {
  defaultMessage: 'View in Lens'
});
let ViewResultsActionButtonType = exports.ViewResultsActionButtonType = /*#__PURE__*/function (ViewResultsActionButtonType) {
  ViewResultsActionButtonType["icon"] = "icon";
  ViewResultsActionButtonType["button"] = "button";
  return ViewResultsActionButtonType;
}({});
function getLensAttributes(logsDataView, actionId) {
  const dataLayer = {
    columnOrder: ['8690befd-fd69-4246-af4a-dd485d2a3b38', 'ed999e9d-204c-465b-897f-fe1a125b39ed'],
    columns: {
      '8690befd-fd69-4246-af4a-dd485d2a3b38': {
        sourceField: 'type',
        isBucketed: true,
        dataType: 'string',
        scale: 'ordinal',
        operationType: 'terms',
        label: 'Top values of type',
        params: {
          otherBucket: true,
          size: 5,
          missingBucket: false,
          orderBy: {
            columnId: 'ed999e9d-204c-465b-897f-fe1a125b39ed',
            type: 'column'
          },
          orderDirection: 'desc'
        }
      },
      'ed999e9d-204c-465b-897f-fe1a125b39ed': {
        sourceField: _constants.DOCUMENT_FIELD_NAME,
        isBucketed: false,
        dataType: 'number',
        scale: 'ratio',
        operationType: 'count',
        label: 'Count of records'
      }
    },
    incompleteColumns: {}
  };
  const xyConfig = {
    shape: 'pie',
    layers: [{
      layerType: 'data',
      legendDisplay: 'default',
      nestedLegend: false,
      layerId: 'layer1',
      metrics: ['ed999e9d-204c-465b-897f-fe1a125b39ed'],
      numberDisplay: 'percent',
      primaryGroups: ['8690befd-fd69-4246-af4a-dd485d2a3b38'],
      categoryDisplay: 'default'
    }]
  };
  return {
    visualizationType: 'lnsPie',
    title: `Action ${actionId} results`,
    references: [{
      id: logsDataView.id,
      name: 'indexpattern-datasource-current-indexpattern',
      type: 'index-pattern'
    }, {
      id: logsDataView.id,
      name: 'indexpattern-datasource-layer-layer1',
      type: 'index-pattern'
    }, {
      name: 'filter-index-pattern-0',
      id: logsDataView.id,
      type: 'index-pattern'
    }],
    state: {
      datasourceStates: {
        formBased: {
          layers: {
            layer1: dataLayer
          }
        }
      },
      filters: [{
        $state: {
          store: _esQuery.FilterStateStore.APP_STATE
        },
        meta: {
          index: 'filter-index-pattern-0',
          negate: false,
          alias: null,
          disabled: false,
          params: {
            query: actionId
          },
          type: 'phrase',
          key: 'action_id'
        },
        query: {
          match_phrase: {
            action_id: actionId
          }
        }
      }],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: xyConfig
    }
  };
}
const ViewResultsInLensActionComponent = ({
  actionId,
  buttonType,
  endDate,
  startDate,
  mode
}) => {
  const lensService = (0, _kibana.useKibana)().services.lens;
  const isLensAvailable = lensService === null || lensService === void 0 ? void 0 : lensService.canUseEditor();
  const {
    data: logsDataView
  } = (0, _use_logs_data_view.useLogsDataView)({
    skip: !actionId,
    checkOnly: true
  });
  const handleClick = (0, _react.useCallback)(event => {
    event.preventDefault();
    if (logsDataView !== null && logsDataView !== void 0 && logsDataView.id) {
      lensService === null || lensService === void 0 ? void 0 : lensService.navigateToPrefilledEditor({
        id: '',
        timeRange: {
          from: startDate !== null && startDate !== void 0 ? startDate : 'now-1d',
          to: endDate !== null && endDate !== void 0 ? endDate : 'now',
          mode: (mode !== null && mode !== void 0 ? mode : startDate || endDate) ? 'absolute' : 'relative'
        },
        attributes: getLensAttributes(logsDataView, actionId)
      }, {
        openInNewTab: true,
        skipAppLeave: true
      });
    }
  }, [actionId, endDate, lensService, logsDataView, mode, startDate]);
  if (!isLensAvailable) {
    return null;
  }
  if (buttonType === ViewResultsActionButtonType.button) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconType: "lensApp",
      onClick: handleClick,
      isDisabled: !logsDataView
    }, VIEW_IN_LENS);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_IN_LENS,
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "lensApp",
    isDisabled: !logsDataView,
    onClick: handleClick,
    "aria-label": VIEW_IN_LENS
  }));
};
const ViewResultsInLensAction = exports.ViewResultsInLensAction = /*#__PURE__*/_react.default.memo(ViewResultsInLensActionComponent);
const ViewResultsInDiscoverActionComponent = ({
  actionId,
  buttonType,
  endDate,
  startDate
}) => {
  const {
    discover,
    application
  } = (0, _kibana.useKibana)().services;
  const locator = discover === null || discover === void 0 ? void 0 : discover.locator;
  const discoverPermissions = application.capabilities.discover_v2;
  const {
    data: logsDataView
  } = (0, _use_logs_data_view.useLogsDataView)({
    skip: !actionId,
    checkOnly: true
  });
  const [discoverUrl, setDiscoverUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const getDiscoverUrl = async () => {
      if (!locator || !logsDataView) return;
      const newUrl = await locator.getUrl({
        indexPatternId: logsDataView.id,
        filters: [{
          meta: {
            index: logsDataView.id,
            alias: null,
            negate: false,
            disabled: false,
            type: 'phrase',
            key: 'action_id',
            params: {
              query: actionId
            }
          },
          query: {
            match_phrase: {
              action_id: actionId
            }
          },
          $state: {
            store: _esQuery.FilterStateStore.APP_STATE
          }
        }],
        refreshInterval: {
          pause: true,
          value: 0
        },
        timeRange: startDate && endDate ? {
          to: endDate,
          from: startDate,
          mode: 'absolute'
        } : {
          to: 'now',
          from: 'now-1d',
          mode: 'relative'
        }
      });
      setDiscoverUrl(newUrl);
    };
    getDiscoverUrl();
  }, [actionId, endDate, startDate, locator, logsDataView]);
  if (!discoverPermissions.show) {
    return null;
  }
  if (buttonType === ViewResultsActionButtonType.button) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconType: "discoverApp",
      href: discoverUrl,
      target: "_blank",
      isDisabled: !logsDataView
    }, VIEW_IN_DISCOVER);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_IN_DISCOVER,
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "discoverApp",
    "aria-label": VIEW_IN_DISCOVER,
    href: discoverUrl,
    target: "_blank",
    isDisabled: !logsDataView
  }));
};
const ViewResultsInDiscoverAction = exports.ViewResultsInDiscoverAction = /*#__PURE__*/_react.default.memo(ViewResultsInDiscoverActionComponent);
const ScheduledQueryExpandedContent = /*#__PURE__*/_react.default.memo(({
  actionId,
  agentIds,
  interval
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "xl"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  paddingSize: "s",
  hasBorder: true,
  hasShadow: false
}, /*#__PURE__*/_react.default.createElement(_scheduled_query_errors_table.ScheduledQueryErrorsTable, {
  actionId: actionId,
  agentIds: agentIds,
  interval: interval
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}))));
ScheduledQueryExpandedContent.displayName = 'ScheduledQueryExpandedContent';
const ScheduledQueryLastResults = ({
  actionId,
  interval
}) => {
  const {
    data: lastResultsData,
    isLoading
  } = (0, _use_pack_query_last_results.usePackQueryLastResults)({
    actionId,
    interval
  });
  const timestamp = (0, _react.useMemo)(() => {
    const dateTime = lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData['@timestamp'];
    if (!dateTime) return undefined;
    return Array.isArray(dateTime) ? dateTime[0] : dateTime;
  }, [lastResultsData]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, timestamp ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: timestamp,
      year: "numeric",
      month: "short",
      day: "2-digit"
    }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
      value: timestamp,
      timeZoneName: "short"
    }))
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "last-results-date",
    tabIndex: 0
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    value: timestamp
  }))) : '-'));
};
const DocsColumnResults = ({
  actionId,
  interval
}) => {
  var _ref;
  const {
    data: lastResultsData,
    isLoading
  } = (0, _use_pack_query_last_results.usePackQueryLastResults)({
    actionId,
    interval
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  if (!lastResultsData) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    "data-test-subj": "docs-count-badge"
  }, (_ref = lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData.docCount) !== null && _ref !== void 0 ? _ref : 0)));
};
const AgentsColumnResults = ({
  actionId,
  interval
}) => {
  var _lastResultsData$uniq;
  const {
    data: lastResultsData,
    isLoading
  } = (0, _use_pack_query_last_results.usePackQueryLastResults)({
    actionId,
    interval
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": 'docsLoading'
    });
  }
  if (!lastResultsData) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    "data-test-subj": "agent-count-badge"
  }, (_lastResultsData$uniq = lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData.uniqueAgentsCount) !== null && _lastResultsData$uniq !== void 0 ? _lastResultsData$uniq : 0)));
};
const ErrorsColumnResults = ({
  actionId,
  interval,
  queryId,
  toggleErrors,
  expanded
}) => {
  var _ref2;
  const handleErrorsToggle = (0, _react.useCallback)(() => toggleErrors({
    queryId,
    interval
  }), [toggleErrors, queryId, interval]);
  const {
    data: errorsData,
    isLoading: errorsLoading
  } = (0, _use_pack_query_errors.usePackQueryErrors)({
    actionId,
    interval
  });
  if (errorsLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  if (!(errorsData !== null && errorsData !== void 0 && errorsData.total)) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "packResultsErrorsEmpty"
    }, '-');
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: errorsData !== null && errorsData !== void 0 && errorsData.total ? 'accent' : 'subdued'
  }, (_ref2 = errorsData === null || errorsData === void 0 ? void 0 : errorsData.total) !== null && _ref2 !== void 0 ? _ref2 : 0)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    isDisabled: !(errorsData !== null && errorsData !== void 0 && errorsData.total),
    onClick: handleErrorsToggle,
    iconType: expanded ? 'arrowUp' : 'arrowDown'
  }))));
};
const getPackActionId = (actionId, packName) => `pack_${packName}_${actionId}`;
const PackViewInDiscoverActionComponent = ({
  item,
  packName
}) => {
  const {
    id,
    interval
  } = item;
  const actionId = getPackActionId(id, packName);
  const {
    data: lastResultsData
  } = (0, _use_pack_query_last_results.usePackQueryLastResults)({
    actionId,
    interval
  });
  const startDate = lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'] ? (0, _momentTimezone.default)(lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData['@timestamp'][0]).subtract(interval, 'seconds').toISOString() : `now-${interval}s`;
  const endDate = lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'] ? (0, _momentTimezone.default)(lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData['@timestamp'][0]).toISOString() : 'now';
  return /*#__PURE__*/_react.default.createElement(ViewResultsInDiscoverAction, {
    actionId: actionId,
    buttonType: ViewResultsActionButtonType.icon,
    startDate: startDate,
    endDate: endDate,
    mode: lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'][0] ? 'absolute' : 'relative'
  });
};
const PackViewInDiscoverAction = /*#__PURE__*/_react.default.memo(PackViewInDiscoverActionComponent);
const PackViewInLensActionComponent = ({
  item,
  packName
}) => {
  const {
    id,
    interval
  } = item;
  const actionId = getPackActionId(id, packName);
  const {
    data: lastResultsData
  } = (0, _use_pack_query_last_results.usePackQueryLastResults)({
    actionId,
    interval
  });
  const startDate = lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'] ? (0, _momentTimezone.default)(lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData['@timestamp'][0]).subtract(interval, 'seconds').toISOString() : `now-${interval}s`;
  const endDate = lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'] ? (0, _momentTimezone.default)(lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData['@timestamp'][0]).toISOString() : 'now';
  return /*#__PURE__*/_react.default.createElement(ViewResultsInLensAction, {
    actionId: actionId,
    buttonType: ViewResultsActionButtonType.icon,
    startDate: startDate,
    endDate: endDate,
    mode: lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'][0] ? 'absolute' : 'relative'
  });
};
const PackViewInLensAction = /*#__PURE__*/_react.default.memo(PackViewInLensActionComponent);
const PackQueriesStatusTableComponent = ({
  agentIds,
  data,
  packName
}) => {
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const renderQueryColumn = (0, _react.useCallback)((query, item) => {
    const singleLine = (0, _remove_multilines.removeMultilines)(query);
    const content = singleLine.length > 55 ? `${singleLine.substring(0, 55)}...` : singleLine;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: item.id,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, query)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "sql",
      fontSize: "s",
      paddingSize: "none",
      transparentBackground: true
    }, content));
  }, []);
  const toggleErrors = (0, _react.useCallback)(({
    queryId,
    interval
  }) => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[queryId]) {
      delete itemIdToExpandedRowMapValues[queryId];
    } else {
      itemIdToExpandedRowMapValues[queryId] = /*#__PURE__*/_react.default.createElement(ScheduledQueryExpandedContent, {
        actionId: getPackActionId(queryId, packName),
        agentIds: agentIds,
        interval: interval
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  }, [agentIds, itemIdToExpandedRowMap, packName]);
  const renderLastResultsColumn = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(ScheduledQueryLastResults, {
    actionId: getPackActionId(item.id, packName),
    interval: item.interval
  }), [packName]);
  const renderDocsColumn = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(DocsColumnResults, {
    actionId: getPackActionId(item.id, packName),
    interval: item.interval
  }), [packName]);
  const renderAgentsColumn = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(AgentsColumnResults, {
    actionId: getPackActionId(item.id, packName),
    interval: item.interval
  }), [packName]);
  const renderErrorsColumn = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(ErrorsColumnResults, {
    queryId: item.id,
    interval: item.interval,
    actionId: getPackActionId(item.id, packName),
    toggleErrors: toggleErrors,
    expanded: !!itemIdToExpandedRowMap[item.id]
  }), [itemIdToExpandedRowMap, packName, toggleErrors]);
  const renderDiscoverResultsAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(PackViewInDiscoverAction, {
    item: item,
    packName: packName
  }), [packName]);
  const renderLensResultsAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(PackViewInLensAction, {
    item: item,
    packName: packName
  }), [packName]);
  const getItemId = (0, _react.useCallback)(item => {
    var _item$id;
    return (_item$id = item.id) !== null && _item$id !== void 0 ? _item$id : '';
  }, []);
  const columns = (0, _react.useMemo)(() => [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.idColumnTitle', {
      defaultMessage: 'ID'
    }),
    width: '15%',
    truncateText: true
  }, {
    field: 'interval',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.intervalColumnTitle', {
      defaultMessage: 'Interval (s)'
    }),
    width: '80px'
  }, {
    field: 'query',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.queryColumnTitle', {
      defaultMessage: 'Query'
    }),
    render: renderQueryColumn,
    width: '40%'
  }, {
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.lastResultsColumnTitle', {
      defaultMessage: 'Last results'
    }),
    render: renderLastResultsColumn,
    width: '12%'
  }, {
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.docsResultsColumnTitle', {
      defaultMessage: 'Docs'
    }),
    render: renderDocsColumn
  }, {
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.agentsResultsColumnTitle', {
      defaultMessage: 'Agents'
    }),
    render: renderAgentsColumn
  }, {
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.errorsResultsColumnTitle', {
      defaultMessage: 'Errors'
    }),
    render: renderErrorsColumn
  }, {
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.viewResultsColumnTitle', {
      defaultMessage: 'View results'
    }),
    width: '90px',
    actions: [{
      render: renderDiscoverResultsAction
    }, {
      render: renderLensResultsAction
    }]
  }], [renderQueryColumn, renderLastResultsColumn, renderDocsColumn, renderAgentsColumn, renderErrorsColumn, renderDiscoverResultsAction, renderLensResultsAction]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: 'id',
      direction: 'asc'
    }
  }), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    // eslint-disable-next-line react-perf/jsx-no-new-array-as-prop
    items: data !== null && data !== void 0 ? data : [],
    itemId: getItemId,
    columns: columns,
    sorting: sorting,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap
  });
};
const PackQueriesStatusTable = exports.PackQueriesStatusTable = /*#__PURE__*/_react.default.memo(PackQueriesStatusTableComponent);