"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listIndicesTool = void 0;
var _zod = require("@kbn/zod");
var _onechatCommon = require("@kbn/onechat-common");
var _onechatGenaiUtils = require("@kbn/onechat-genai-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const listIndicesSchema = _zod.z.object({
  pattern: _zod.z.string().optional().describe('(optional) pattern to filter indices by. Defaults to *. Leave empty to list all indices (recommended)')
});
const listIndicesTool = () => {
  return {
    id: _onechatCommon.BuiltinToolIds.listIndices,
    description: 'List the indices in the Elasticsearch cluster the current user has access to.',
    schema: listIndicesSchema,
    handler: async ({
      pattern = '*'
    }, {
      esClient
    }) => {
      return (0, _onechatGenaiUtils.listIndices)({
        pattern,
        esClient: esClient.asCurrentUser
      });
    },
    meta: {
      tags: [_onechatCommon.BuiltinTags.retrieval]
    }
  };
};
exports.listIndicesTool = listIndicesTool;