"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeEsqlTool = void 0;
var _zod = require("@kbn/zod");
var _onechatCommon = require("@kbn/onechat-common");
var _onechatGenaiUtils = require("@kbn/onechat-genai-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const executeEsqlToolSchema = _zod.z.object({
  query: _zod.z.string().describe('The ES|QL query to execute')
});
const executeEsqlTool = () => {
  return {
    id: _onechatCommon.BuiltinToolIds.executeEsql,
    description: 'Execute an ES|QL query and return the results.',
    schema: executeEsqlToolSchema,
    handler: async ({
      query
    }, {
      esClient
    }) => {
      return (0, _onechatGenaiUtils.executeEsql)({
        query,
        esClient: esClient.asCurrentUser
      });
    },
    meta: {
      tags: [_onechatCommon.BuiltinTags.retrieval]
    }
  };
};
exports.executeEsqlTool = executeEsqlTool;