"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.forkContextForToolRun = exports.forkContextForAgentRun = exports.createEmptyRunContext = void 0;
var _uuid = require("uuid");
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEmptyRunContext = ({
  runId = (0, _uuid.v4)()
} = {}) => {
  return {
    runId,
    stack: []
  };
};
exports.createEmptyRunContext = createEmptyRunContext;
const forkContextForToolRun = ({
  toolId,
  parentContext
}) => {
  return {
    ...parentContext,
    stack: [...parentContext.stack, {
      type: 'tool',
      toolId: (0, _onechatCommon.toSerializedToolIdentifier)(toolId)
    }]
  };
};
exports.forkContextForToolRun = forkContextForToolRun;
const forkContextForAgentRun = ({
  agentId,
  parentContext
}) => {
  return {
    ...parentContext,
    stack: [...parentContext.stack, {
      type: 'agent',
      agentId: (0, _onechatCommon.toSerializedAgentIdentifier)(agentId)
    }]
  };
};
exports.forkContextForAgentRun = forkContextForAgentRun;