"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runTool = exports.createToolHandlerContext = void 0;
var _utils = require("../tools/utils");
var _run_context = require("./utils/run_context");
var _events = require("./utils/events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runTool = async ({
  toolExecutionParams,
  parentManager
}) => {
  const {
    toolId,
    toolParams
  } = toolExecutionParams;
  const context = (0, _run_context.forkContextForToolRun)({
    parentContext: parentManager.context,
    toolId
  });
  const manager = parentManager.createChild(context);
  const {
    toolsService,
    request
  } = manager.deps;
  const tool = await toolsService.registry.get({
    toolId,
    request
  });
  const toolHandlerContext = createToolHandlerContext({
    toolExecutionParams,
    manager
  });
  const toolResult = await tool.handler(toolParams, toolHandlerContext);
  return {
    runId: manager.context.runId,
    result: toolResult
  };
};
exports.runTool = runTool;
const createToolHandlerContext = ({
  manager,
  toolExecutionParams
}) => {
  const {
    onEvent
  } = toolExecutionParams;
  const {
    request,
    defaultConnectorId,
    elasticsearch,
    modelProviderFactory,
    toolsService,
    logger
  } = manager.deps;
  return {
    request,
    logger,
    esClient: elasticsearch.client.asScoped(request),
    modelProvider: modelProviderFactory({
      request,
      defaultConnectorId
    }),
    runner: manager.getRunner(),
    toolProvider: (0, _utils.internalProviderToPublic)({
      provider: toolsService.registry,
      getRunner: manager.getRunner
    }),
    events: (0, _events.createToolEventEmitter)({
      eventHandler: onEvent,
      context: manager.context
    })
  };
};
exports.createToolHandlerContext = createToolHandlerContext;