"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runAgent = exports.createAgentHandlerContext = void 0;
var _utils = require("../tools/utils");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAgentHandlerContext = ({
  agentExecutionParams,
  manager
}) => {
  const {
    onEvent
  } = agentExecutionParams;
  const {
    request,
    defaultConnectorId,
    elasticsearch,
    modelProviderFactory,
    toolsService,
    logger
  } = manager.deps;
  return {
    request,
    logger,
    esClient: elasticsearch.client.asScoped(request),
    modelProvider: modelProviderFactory({
      request,
      defaultConnectorId
    }),
    runner: manager.getRunner(),
    toolProvider: (0, _utils.internalProviderToPublic)({
      provider: toolsService.registry,
      getRunner: manager.getRunner
    }),
    events: (0, _utils2.createAgentEventEmitter)({
      eventHandler: onEvent,
      context: manager.context
    })
  };
};
exports.createAgentHandlerContext = createAgentHandlerContext;
const runAgent = async ({
  agentExecutionParams,
  parentManager
}) => {
  const {
    agentId,
    agentParams
  } = agentExecutionParams;
  const context = (0, _utils2.forkContextForAgentRun)({
    parentContext: parentManager.context,
    agentId
  });
  const manager = parentManager.createChild(context);
  const {
    agentsService,
    request
  } = manager.deps;
  const agent = await agentsService.registry.get({
    agentId,
    request
  });
  const agentHandlerContext = createAgentHandlerContext({
    agentExecutionParams,
    manager
  });
  const agentResult = await agent.handler({
    runId: manager.context.runId,
    agentParams: agentParams
  }, agentHandlerContext);
  return {
    runId: manager.context.runId,
    result: agentResult.result
  };
};
exports.runAgent = runAgent;