"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStorage = exports.conversationIndexName = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const conversationIndexName = exports.conversationIndexName = '.kibana_onechat_conversations';
const storageSettings = {
  name: conversationIndexName,
  schema: {
    properties: {
      user_id: _storageAdapter.types.keyword({}),
      user_name: _storageAdapter.types.keyword({}),
      agent_id: _storageAdapter.types.keyword({}),
      agent_provider_id: _storageAdapter.types.keyword({}),
      title: _storageAdapter.types.text({}),
      created_at: _storageAdapter.types.date({}),
      updated_at: _storageAdapter.types.date({}),
      rounds: _storageAdapter.types.object({
        dynamic: true
      })
    }
  }
};
const createStorage = ({
  logger,
  esClient
}) => {
  return new _storageAdapter.StorageIndexAdapter(esClient, logger, storageSettings);
};
exports.createStorage = createStorage;