"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runAgent = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _chat = require("./chat");
var _reasoning = require("./reasoning");
var _planner = require("./planner");
var _researcher = require("./researcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runAgent = async (params, context) => {
  const {
    mode,
    ...modeParams
  } = params;
  switch (mode) {
    case _onechatCommon.AgentMode.research:
      return (0, _researcher.runResearcherAgent)(modeParams, context);
    case _onechatCommon.AgentMode.plan:
      return (0, _planner.runPlannerAgent)(modeParams, context);
    case _onechatCommon.AgentMode.reason:
      return (0, _reasoning.runReasoningAgent)(modeParams, context);
    case _onechatCommon.AgentMode.normal:
      return (0, _chat.runChatAgent)(modeParams, context);
  }
};
exports.runAgent = runAgent;