"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runResearcherAgent = void 0;
var _rxjs = require("rxjs");
var _onechatCommon = require("@kbn/onechat-common");
var _langchain = require("@kbn/onechat-genai-utils/langchain");
var _framework = require("@kbn/onechat-genai-utils/framework");
var _utils = require("../utils");
var _graph = require("./graph");
var _convert_graph_events = require("./convert_graph_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const agentGraphName = 'researcher-agent';
const defaultCycleBudget = 5;

/**
 * Create the handler function for the default onechat agent.
 */
const runResearcherAgent = async ({
  nextInput,
  conversation = [],
  cycleBudget = defaultCycleBudget,
  tools
}, {
  logger,
  request,
  modelProvider,
  toolProvider,
  events
}) => {
  const model = await modelProvider.getDefaultModel();

  // TODO: use tools param instead of tool provider
  const researcherTools = await (0, _framework.filterProviderTools)({
    request,
    provider: toolProvider,
    rules: [{
      type: 'by_tool_id',
      providerId: _onechatCommon.builtinToolProviderId,
      toolIds: [_onechatCommon.BuiltinToolIds.relevanceSearch, _onechatCommon.BuiltinToolIds.naturalLanguageSearch, _onechatCommon.BuiltinToolIds.indexExplorer, _onechatCommon.BuiltinToolIds.getDocumentById]
    }]
  });
  const {
    tools: langchainTools,
    idMappings: toolIdMapping
  } = await (0, _langchain.toolsToLangchain)({
    tools: researcherTools,
    logger,
    request
  });
  const initialMessages = (0, _utils.conversationToLangchainMessages)({
    nextInput,
    previousRounds: conversation,
    ignoreSteps: true
  });
  const agentGraph = await (0, _graph.createResearcherAgentGraph)({
    logger,
    chatModel: model.chatModel,
    tools: langchainTools
  });
  const eventStream = agentGraph.streamEvents({
    initialMessages,
    cycleBudget
  }, {
    version: 'v2',
    runName: agentGraphName,
    metadata: {
      graphName: agentGraphName
    },
    recursionLimit: cycleBudget * 10,
    callbacks: []
  });
  const events$ = (0, _rxjs.from)(eventStream).pipe((0, _rxjs.filter)(_langchain.isStreamEvent), (0, _convert_graph_events.convertGraphEvents)({
    graphName: agentGraphName,
    toolIdMapping
  }), (0, _utils.addRoundCompleteEvent)({
    userInput: nextInput
  }), (0, _rxjs.shareReplay)());
  events$.subscribe(event => {
    events.emit(event);
  });
  const round = await (0, _utils.extractRound)(events$);
  return {
    round
  };
};
exports.runResearcherAgent = runResearcherAgent;