"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractToolResults = void 0;
var _messages = require("@langchain/core/messages");
var _langchain = require("@kbn/onechat-genai-utils/langchain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractToolResults = messages => {
  const results = [];
  for (const message of messages) {
    if ((0, _messages.isToolMessage)(message)) {
      results.push({
        toolCallId: message.tool_call_id,
        result: (0, _langchain.extractTextContent)(message)
      });
    }
  }
  return results;
};
exports.extractToolResults = extractToolResults;