"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listIndices = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const listIndices = async ({
  pattern = '*',
  esClient
}) => {
  const response = await esClient.cat.indices({
    index: pattern,
    format: 'json'
  });
  return response.map(({
    index,
    status,
    health,
    uuid,
    'docs.count': docsCount,
    pri,
    rep
  }) => ({
    index: index !== null && index !== void 0 ? index : 'unknown',
    status: status !== null && status !== void 0 ? status : 'unknown',
    health: health !== null && health !== void 0 ? health : 'unknown',
    uuid: uuid !== null && uuid !== void 0 ? uuid : 'unknown',
    docsCount: parseInt(docsCount !== null && docsCount !== void 0 ? docsCount : '0', 10),
    primaries: parseInt(pri !== null && pri !== void 0 ? pri : '1', 10),
    replicas: parseInt(rep !== null && rep !== void 0 ? rep : '0', 10)
  }));
};
exports.listIndices = listIndices;