"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InventoryLocatorDefinition = exports.INVENTORY_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _querystring = _interopRequireDefault(require("querystring"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVENTORY_LOCATOR_ID = exports.INVENTORY_LOCATOR_ID = 'INVENTORY_LOCATOR';
class InventoryLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", INVENTORY_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      var _params$waffleFilter, _params$waffleTime, _params$waffleOptions, _params$groupBy, _params$legend, _params$region, _params$sort, _params$timelineOpen, _params$view;
      const paramsWithDefaults = {
        waffleFilter: _rison.default.encodeUnknown((_params$waffleFilter = params.waffleFilter) !== null && _params$waffleFilter !== void 0 ? _params$waffleFilter : {
          kind: 'kuery',
          expression: ''
        }),
        waffleTime: _rison.default.encodeUnknown((_params$waffleTime = params.waffleTime) !== null && _params$waffleTime !== void 0 ? _params$waffleTime : {
          currentTime: new Date().getTime(),
          isAutoReloading: false
        }),
        waffleOptions: _rison.default.encodeUnknown((_params$waffleOptions = params.waffleOptions) !== null && _params$waffleOptions !== void 0 ? _params$waffleOptions : {
          accountId: '',
          autoBounds: true,
          boundsOverride: {
            max: 1,
            min: 0
          }
        }),
        customMetrics: params.customMetrics,
        customOptions: params.customOptions,
        groupBy: _rison.default.encodeUnknown((_params$groupBy = params.groupBy) !== null && _params$groupBy !== void 0 ? _params$groupBy : {}),
        legend: _rison.default.encodeUnknown((_params$legend = params.legend) !== null && _params$legend !== void 0 ? _params$legend : {
          palette: 'cool',
          reverseColors: false,
          steps: 10
        }),
        metric: params.metric,
        nodeType: _rison.default.encodeUnknown(params.nodeType),
        region: _rison.default.encodeUnknown((_params$region = params.region) !== null && _params$region !== void 0 ? _params$region : ''),
        sort: _rison.default.encodeUnknown((_params$sort = params.sort) !== null && _params$sort !== void 0 ? _params$sort : {
          by: 'name',
          direction: 'desc'
        }),
        timelineOpen: _rison.default.encodeUnknown((_params$timelineOpen = params.timelineOpen) !== null && _params$timelineOpen !== void 0 ? _params$timelineOpen : false),
        view: _rison.default.encodeUnknown((_params$view = params.view) !== null && _params$view !== void 0 ? _params$view : 'map')
      };
      const queryStringParams = _querystring.default.stringify(paramsWithDefaults);
      return {
        app: 'metrics',
        path: `/inventory?${queryStringParams}`,
        state: params.state ? params.state : {}
      };
    });
  }
}
exports.InventoryLocatorDefinition = InventoryLocatorDefinition;