"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderMenu = HeaderMenu;
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_plugin_context = require("../../../../hooks/use_plugin_context");
var _kibana_react = require("../../../../utils/kibana_react");
var _inspector_header_link = require("../../../alert_details/components/inspector_header_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderMenu() {
  const {
    share,
    theme,
    http
  } = (0, _kibana_react.useKibana)().services;
  const onboardingLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const href = onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.useUrl({});
  const {
    appMountParameters
  } = (0, _use_plugin_context.usePluginContext)();
  return /*#__PURE__*/_react.default.createElement(_public.HeaderMenuPortal, {
    setHeaderActionMenu: appMountParameters === null || appMountParameters === void 0 ? void 0 : appMountParameters.setHeaderActionMenu,
    theme$: theme.theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: http.basePath.prepend('/app/observability/annotations')
  }, _i18n.i18n.translate('xpack.observability.home.annotations', {
    defaultMessage: 'Annotations'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: href
  }, _i18n.i18n.translate('xpack.observability.home.addData', {
    defaultMessage: 'Add data'
  })), /*#__PURE__*/_react.default.createElement(_inspector_header_link.InspectorHeaderLink, null)))));
}