"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBar = StatusBar;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _alert_lifecycle_status_badge = require("@kbn/alerts-ui-shared/src/alert_lifecycle_status_badge");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react2 = require("@emotion/react");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _formatters = require("../../../../common/utils/formatters");
var _case_links = require("./case_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StatusBar({
  alert,
  alertStatus
}) {
  var _alert$fields$TIMESTA;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dateFormat = (0, _public2.useUiSetting)('dateFormat');
  const tags = alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.TAGS];
  if (!alert) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "m",
    "data-test-subj": "statusBar",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, alertStatus && /*#__PURE__*/_react.default.createElement(_alert_lifecycle_status_badge.AlertLifecycleStatusBadge, {
    alertStatus: alertStatus,
    flapping: alert.fields[_ruleDataUtils.ALERT_FLAPPING]
  })), /*#__PURE__*/_react.default.createElement(_case_links.CaseLinks, {
    alert: alert
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public.TagsList, {
    tags: tags,
    ignoreEmpty: true,
    color: "default"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.pages.alertDetails.pageTitle.triggered",
    defaultMessage: "Triggered"
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (0, _moment.default)(Number(alert.start)).format(dateFormat)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.semiBold};
              `,
    size: "s"
  }, (0, _moment.default)(Number(alert.start)).locale(_i18n.i18n.getLocale()).fromNow())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 120
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.pages.alertDetails.pageTitle.duration",
    defaultMessage: "Duration"
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
            `,
    size: "s"
  }, (0, _formatters.asDuration)(Number(alert.fields[_ruleDataUtils.ALERT_DURATION]))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 240
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.pages.alertDetails.pageTitle.lastStatusUpdate",
    defaultMessage: "Last status update"
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (0, _moment.default)(alert.fields[_ruleDataUtils.TIMESTAMP]).format(dateFormat)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.semiBold};
              `,
    size: "s"
  }, (0, _moment.default)((_alert$fields$TIMESTA = alert.fields[_ruleDataUtils.TIMESTAMP]) === null || _alert$fields$TIMESTA === void 0 ? void 0 : _alert$fields$TIMESTA.toString()).locale(_i18n.i18n.getLocale()).fromNow())))));
}