"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAlertsTable = ObservabilityAlertsTable;
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _alert_actions = _interopRequireDefault(require("../alert_actions/alert_actions"));
var _kibana_react = require("../../utils/kibana_react");
var _common = require("../../../common");
var _cell_value = require("./common/cell_value");
var _alerts_flyout_body = require("../alerts_flyout/alerts_flyout_body");
var _alerts_flyout_header = require("../alerts_flyout/alerts_flyout_header");
var _alerts_flyout_footer = require("../alerts_flyout/alerts_flyout_footer");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _get_columns = require("./common/get_columns");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columns = (0, _get_columns.getColumns)({
  showRuleName: true
});
const initialSort = [{
  [_ruleDataUtils.ALERT_START]: {
    order: 'desc'
  }
}];
const caseConfiguration = {
  featureId: _common.casesFeatureId,
  owner: [_common.observabilityFeatureId]
};
function ObservabilityAlertsTable(props) {
  const {
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    cases,
    settings,
    observability
  } = (0, _kibana_react.useKibana)().services;
  const {
    observabilityRuleTypeRegistry,
    config
  } = (0, _use_plugin_context.usePluginContext)();
  return /*#__PURE__*/_react.default.createElement(_responseOpsAlertsTable.AlertsTable, (0, _extends2.default)({
    columns: columns,
    ruleTypeIds: _constants.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    initialSort: initialSort,
    casesConfiguration: caseConfiguration,
    additionalContext: {
      observabilityRuleTypeRegistry: observabilityRuleTypeRegistry !== null && observabilityRuleTypeRegistry !== void 0 ? observabilityRuleTypeRegistry : observability === null || observability === void 0 ? void 0 : observability.observabilityRuleTypeRegistry,
      config
    },
    renderCellValue: _cell_value.AlertsTableCellValue,
    renderActionsCell: _alert_actions.default,
    actionsColumnWidth: 120,
    renderFlyoutHeader: _alerts_flyout_header.AlertsFlyoutHeader,
    renderFlyoutBody: _alerts_flyout_body.AlertsFlyoutBody,
    renderFlyoutFooter: _alerts_flyout_footer.AlertsFlyoutFooter,
    showAlertStatusWithFlapping: true,
    services: {
      data,
      http,
      notifications,
      fieldFormats,
      application,
      licensing,
      cases,
      settings
    }
  }, props));
}

// Lazy loading helpers
// eslint-disable-next-line import/no-default-export
var _default = exports.default = ObservabilityAlertsTable;