"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSources = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_alert_source_links = require("./get_alert_source_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isGroup = item => {
  return !!item;
};
const getSources = alert => {
  var _alert$fields$ALERT_G;
  // when `kibana.alert.group` is not flattened (for alert detail pages)
  if (alert.fields[_ruleDataUtils.ALERT_GROUP]) return alert.fields[_ruleDataUtils.ALERT_GROUP];

  // when `kibana.alert.group` is flattened (for alert flyout)
  const groupsFromGroupFields = (_alert$fields$ALERT_G = alert.fields[_ruleDataUtils.ALERT_GROUP_FIELD]) === null || _alert$fields$ALERT_G === void 0 ? void 0 : _alert$fields$ALERT_G.map((field, index) => {
    const values = alert.fields[_ruleDataUtils.ALERT_GROUP_VALUE];
    if (values !== null && values !== void 0 && values.length && values[index]) {
      const group = {
        field,
        value: values[index]
      };
      return group;
    }
  }).filter(isGroup);
  if (groupsFromGroupFields !== null && groupsFromGroupFields !== void 0 && groupsFromGroupFields.length) return groupsFromGroupFields;

  // Not all rules has group.fields, in that case we search in the alert fields.
  const matchedSources = [];
  const ALL_SOURCES = [..._get_alert_source_links.infraSources, ..._get_alert_source_links.apmSources];
  const alertFields = alert.fields;
  ALL_SOURCES.forEach(source => {
    Object.keys(alertFields).forEach(field => {
      if (source === field) {
        const fieldValue = alertFields[field];
        matchedSources.push({
          field: source,
          value: Array.isArray(fieldValue) ? fieldValue[0] : fieldValue
        });
      }
    });
  });
  return matchedSources;
};
exports.getSources = getSources;