"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.relativePaths = exports.paths = exports.SLO_DETAIL_PATH = exports.SETTINGS_PATH = exports.RULE_DETAIL_PATH = exports.RULES_PATH = exports.RULES_LOGS_PATH = exports.ROOT_PATH = exports.OVERVIEW_PATH = exports.OLD_SLO_EDIT_PATH = exports.OLD_SLO_DETAIL_PATH = exports.OLD_SLOS_WELCOME_PATH = exports.OLD_SLOS_PATH = exports.OLD_SLOS_OUTDATED_DEFINITIONS_PATH = exports.OBSERVABILITY_BASE_PATH = exports.LANDING_PATH = exports.EXPLORATORY_VIEW_PATH = exports.EDIT_RULE_PATH = exports.CREATE_RULE_PATH = exports.CASES_PATH = exports.ANNOTATIONS_PATH = exports.ALERT_DETAIL_PATH = exports.ALERTS_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVABILITY_BASE_PATH = exports.OBSERVABILITY_BASE_PATH = '/app/observability';
const ROOT_PATH = exports.ROOT_PATH = '/';
const LANDING_PATH = exports.LANDING_PATH = '/landing';
const OVERVIEW_PATH = exports.OVERVIEW_PATH = '/overview';
const ALERTS_PATH = exports.ALERTS_PATH = '/alerts';
const ALERT_DETAIL_PATH = exports.ALERT_DETAIL_PATH = '/alerts/:alertId';
const EXPLORATORY_VIEW_PATH = exports.EXPLORATORY_VIEW_PATH = '/exploratory-view'; // has been moved to its own app. Keeping around for redirecting purposes.
const RULES_PATH = exports.RULES_PATH = '/alerts/rules';
const RULES_LOGS_PATH = exports.RULES_LOGS_PATH = '/alerts/rules/logs';
const RULE_DETAIL_PATH = exports.RULE_DETAIL_PATH = '/alerts/rules/:ruleId';
const CREATE_RULE_PATH = exports.CREATE_RULE_PATH = '/alerts/rules/create/:ruleTypeId';
const EDIT_RULE_PATH = exports.EDIT_RULE_PATH = '/alerts/rules/edit/:id';
const CASES_PATH = exports.CASES_PATH = '/cases';
const ANNOTATIONS_PATH = exports.ANNOTATIONS_PATH = '/annotations';
const SETTINGS_PATH = exports.SETTINGS_PATH = '/slos/settings';

// // SLOs have been moved to its own app (slo). Keeping around for redirecting purposes.
const OLD_SLOS_PATH = exports.OLD_SLOS_PATH = '/slos';
const OLD_SLOS_WELCOME_PATH = exports.OLD_SLOS_WELCOME_PATH = '/slos/welcome';
const OLD_SLOS_OUTDATED_DEFINITIONS_PATH = exports.OLD_SLOS_OUTDATED_DEFINITIONS_PATH = '/slos/outdated-definitions';
const OLD_SLO_DETAIL_PATH = exports.OLD_SLO_DETAIL_PATH = '/slos/:sloId';
const OLD_SLO_EDIT_PATH = exports.OLD_SLO_EDIT_PATH = '/slos/edit/:sloId';
const SLO_DETAIL_PATH = exports.SLO_DETAIL_PATH = '/:sloId';
const paths = exports.paths = {
  observability: {
    alerts: `${OBSERVABILITY_BASE_PATH}${ALERTS_PATH}`,
    annotations: `${OBSERVABILITY_BASE_PATH}${ANNOTATIONS_PATH}`,
    alertDetails: alertId => `${OBSERVABILITY_BASE_PATH}${ALERTS_PATH}/${encodeURIComponent(alertId)}`,
    rules: `${OBSERVABILITY_BASE_PATH}${RULES_PATH}`,
    ruleDetails: ruleId => `${OBSERVABILITY_BASE_PATH}${RULES_PATH}/${encodeURIComponent(ruleId)}`,
    createRule: ruleTypeId => `${OBSERVABILITY_BASE_PATH}${RULES_PATH}/create/${encodeURIComponent(ruleTypeId)}`,
    editRule: id => `${OBSERVABILITY_BASE_PATH}${RULES_PATH}/edit/${encodeURIComponent(id)}`
  }
};
const relativePaths = exports.relativePaths = {
  observability: {
    ruleDetails: ruleId => `${RULES_PATH}/${encodeURIComponent(ruleId)}`,
    editRule: id => `${RULES_PATH}/edit/${encodeURIComponent(id)}`
  }
};