"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityRuleCreationValidConsumers = exports.observabilityAlertFeatureIds = exports.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES = exports.INVALID_EQUATION_REGEX = exports.EventsAsUnit = exports.ALERT_STATUS_ALL = exports.ALERTS_URL_STORAGE_KEY = exports.ALERTS_API_URLS = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVALID_EQUATION_REGEX = exports.INVALID_EQUATION_REGEX = /[^A-Z|+|\-|\s|\d+|\.|\(|\)|\/|\*|>|<|=|\?|\:|&|\!|\|]+/g;
const ALERT_STATUS_ALL = exports.ALERT_STATUS_ALL = 'all';
const ALERTS_URL_STORAGE_KEY = exports.ALERTS_URL_STORAGE_KEY = '_a';
const observabilityAlertFeatureIds = exports.observabilityAlertFeatureIds = [_ruleDataUtils.AlertConsumers.APM, _ruleDataUtils.AlertConsumers.INFRASTRUCTURE, _ruleDataUtils.AlertConsumers.LOGS, _ruleDataUtils.AlertConsumers.UPTIME, _ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.OBSERVABILITY, _ruleDataUtils.AlertConsumers.ALERTS];
const observabilityRuleCreationValidConsumers = exports.observabilityRuleCreationValidConsumers = [_ruleDataUtils.AlertConsumers.INFRASTRUCTURE, _ruleDataUtils.AlertConsumers.LOGS];
const EventsAsUnit = exports.EventsAsUnit = 'events';
const OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES = exports.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES = [..._ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS, ..._ruleDataUtils.STACK_RULE_TYPE_IDS_SUPPORTED_BY_OBSERVABILITY];
let ALERTS_API_URLS = exports.ALERTS_API_URLS = /*#__PURE__*/function (ALERTS_API_URLS) {
  ALERTS_API_URLS["INTERNAL_RELATED_DASHBOARDS"] = "/internal/observability/alerts/related_dashboards";
  return ALERTS_API_URLS;
}({});