"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackButton = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BackButton = ({
  children
}) => {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const location = (0, _reactRouterDomV5Compat.useLocation)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilityOnboardingFlowBackToSelectionButton",
    iconType: "arrowLeft",
    flush: "left",
    onClick: () => navigate(`../${location.search}`)
  }, children ? children : _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.button.backToSelectionLabel', {
    defaultMessage: 'Back to selection'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.BackButton = BackButton;