"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetStartedPanel = GetStartedPanel;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _telemetry_events = require("../../../../common/telemetry_events");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GetStartedPanel({
  onboardingFlowType,
  dataset,
  integration,
  actionLinks,
  previewImage = 'charts_screen.svg',
  newTab,
  isLoading,
  onboardingId,
  telemetryEventContext
}) {
  const {
    services: {
      http,
      analytics
    }
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    analytics === null || analytics === void 0 ? void 0 : analytics.reportEvent(_telemetry_events.OBSERVABILITY_ONBOARDING_FLOW_DATASET_DETECTED_TELEMETRY_EVENT.eventType, {
      onboardingFlowType,
      onboardingId,
      dataset,
      context: telemetryEventContext
    });
    /**
     * Firing the event only once when the component mounts
     */
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: 162,
    height: 117
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: http.staticAssets.getPluginAssetHref(previewImage),
    width: 162,
    height: 117,
    alt: "",
    hasShadow: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, actionLinks.map(({
    id,
    title,
    label,
    href
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    key: id,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `observabilityOnboardingDataIngestStatusActionLink-${id}`,
    "data-onboarding-id": onboardingId,
    href: href,
    target: newTab ? '_blank' : '_self'
  }, label))))))), integration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.dataIngestStatus.findAllPremadeAssetsTextLabel",
    defaultMessage: "Find all pre-made assets ready to use {viewAllAssetsLink}",
    values: {
      viewAllAssetsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        "data-test-subj": "observabilityOnboardingDataIngestStatusViewAllAssetsLink",
        href: `${http.basePath.get()}/app/integrations/detail/${integration}/assets`
      }, _i18n.i18n.translate('xpack.observability_onboarding.dataIngestStatus.viewAllAssetsLinkText', {
        defaultMessage: 'View all assets'
      }))
    }
  }))));
}