"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandSnippet = CommandSnippet;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _build_kubectl_command = require("./build_kubectl_command");
var _copy_to_clipboard_button = require("../shared/copy_to_clipboard_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CommandSnippet({
  encodedApiKey,
  onboardingId,
  elasticsearchUrl,
  elasticAgentVersionInfo,
  isCopyPrimaryAction
}) {
  const command = (0, _build_kubectl_command.buildKubectlCommand)({
    encodedApiKey,
    onboardingId,
    elasticsearchUrl,
    elasticAgentVersionInfo
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.kubernetesPanel.installElasticAgentDescription",
    defaultMessage: "Copy and run the install command. Note that the following manifest contains resource limits that may not be appropriate for a production environment, review our guide on {scalingLink} before deploying this manifest.",
    values: {
      scalingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "observabilityOnboardingKubernetesPanelScalingElasticAgentOnKubernetesLink",
        href: "https://www.elastic.co/guide/en/fleet/current/scaling-on-kubernetes.html",
        external: true,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.observability_onboarding.kubernetesPanel.scalingElasticAgentOnLinkLabel', {
        defaultMessage: 'Scaling Elastic Agent on Kubernetes'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "text",
    paddingSize: "m",
    fontSize: "m",
    "data-test-subj": "observabilityOnboardingKubernetesPanelCodeSnippet"
  }, command), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard_button.CopyToClipboardButton, {
    textToCopy: command,
    fill: isCopyPrimaryAction
  }));
}