"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightBase = InsightBase;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InsightBase({
  title,
  description = _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.defaultDescription', {
    defaultMessage: 'Get helpful insights from our Elastic AI Assistant.'
  }),
  controls,
  children,
  actions,
  onToggle,
  loading,
  isOpen,
  dataTestSubj = 'obsAiAssistantInsightButton'
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isActionsPopoverOpen, setIsActionsPopover] = (0, _react.useState)(false);
  const handleClickActions = () => {
    setIsActionsPopover(!isActionsPopoverOpen);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "obsAiAssistantInsightContainer",
    arrowProps: {
      css: {
        alignSelf: 'flex-start'
      }
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      responsive: false,
      gutterSize: "m",
      "data-test-subj": dataTestSubj
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: {
        marginTop: 2,
        marginBottom: 1
      }
    }, /*#__PURE__*/_react.default.createElement("h5", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.iconTooltip', {
        defaultMessage: 'Every contextual insight can be changed with a custom prompt defined by the user. You can always reset it to the default.'
      }),
      position: "right"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: {
        color: euiTheme.colors.textSubdued
      }
    }, /*#__PURE__*/_react.default.createElement("span", null, description)))),
    isLoading: loading,
    isDisabled: loading,
    forceState: isOpen ? 'open' : 'closed',
    extraAction: actions !== null && actions !== void 0 && actions.length || controls ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      responsive: false
    }, controls && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, controls), actions !== null && actions !== void 0 && actions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downLeft",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.actions', {
          defaultMessage: 'Actions'
        }),
        color: "text",
        css: {
          alignSelf: 'flex-start'
        },
        "data-test-subj": "observabilityAiAssistantInsightBaseButtonIcon",
        disabled: (actions === null || actions === void 0 ? void 0 : actions.length) === 0,
        display: "empty",
        iconType: "boxesHorizontal",
        size: "s",
        onClick: handleClickActions
      }),
      panelPaddingSize: "s",
      closePopover: handleClickActions,
      isOpen: isActionsPopoverOpen
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: actions === null || actions === void 0 ? void 0 : actions.map(({
        id,
        icon,
        label,
        handler
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: id,
        icon: icon,
        onClick: handler
      }, label))
    }))) : null) : null,
    onToggle: onToggle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    color: "subdued",
    "data-test-subj": "obsAiAssistantInsightResponse"
  }, children)));
}