"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelectorBase = ConnectorSelectorBase;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapperClassName = (0, _css.css)`
  height: 32px;

  .euiSuperSelectControl {
    border: none;
    box-shadow: none;
    background: none;
    padding-left: 0;
  }
`;
const smallFontClassName = (0, _css.css)`
  font-size: 12px;
`;
function ConnectorSelectorBase(props) {
  var _props$connectors;
  if (props.loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      className: wrapperClassName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    })));
  }
  if (props.error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      gutterSize: "s",
      className: wrapperClassName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger",
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.connectorSelector.error', {
      defaultMessage: 'Failed to load connectors'
    }))));
  }
  if (!((_props$connectors = props.connectors) !== null && _props$connectors !== void 0 && _props$connectors.length)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      gutterSize: "s",
      className: wrapperClassName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "warning"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.connectorSelector.empty', {
      defaultMessage: 'No connectors'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: wrapperClassName,
    direction: "row",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    compressed: true,
    valueOfSelected: props.selectedConnector,
    options: props.connectors.map(connector => ({
      value: connector.id,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, _i18n.i18n.translate('xpack.observabilityAiAssistant.connectorSelector.connectorSelectLabel', {
        defaultMessage: 'Connector:'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        text: connector.name,
        className: smallFontClassName,
        truncation: "end"
      }))),
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, connector.name)
    })),
    onChange: id => {
      props.selectConnector(id);
    }
  })));
}