"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.insightResponseEventSchema = void 0;
var _telemetry_event_type = require("../telemetry_event_type");
var _analytics = require("../../../common/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const insightResponseEventSchema = exports.insightResponseEventSchema = {
  eventType: _telemetry_event_type.ObservabilityAIAssistantTelemetryEventType.InsightResponse,
  schema: {
    '@timestamp': {
      type: 'text',
      _meta: {
        description: 'The timestamp of the last response from the LLM.'
      }
    },
    connector: {
      properties: _analytics.connectorSchema
    },
    scopes: _analytics.scopeSchema
  }
};