"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BottomBarActions = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BottomBarActions = ({
  isLoading,
  onDiscardChanges,
  onSave,
  unsavedChangesCount,
  saveLabel,
  appTestSubj,
  areChangesInvalid = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      flexDirection: 'row',
      alignItems: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.bottomBarActions.unsavedChanges', {
    defaultMessage: '{unsavedChangesCount, plural, =0{0 unsaved changes} one {1 unsaved change} other {# unsaved changes}} ',
    values: {
      unsavedChangesCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `${appTestSubj}BottomBarActionsDiscardChangesButton`,
    color: "text",
    onClick: onDiscardChanges
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.bottomBarActions.discardChangesButton', {
    defaultMessage: 'Discard changes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: areChangesInvalid && _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.bottomBarActions.saveButtonTooltipWithInvalidChanges', {
      defaultMessage: 'Fix invalid settings before saving.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: areChangesInvalid,
    "data-test-subj": `${appTestSubj}BottomBarActionsButton`,
    onClick: onSave,
    fill: true,
    isLoading: isLoading,
    color: "success",
    iconType: "check"
  }, saveLabel)))))));
};
exports.BottomBarActions = BottomBarActions;