"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetUserInstructions = useGetUserInstructions;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetUserInstructions() {
  const {
    observabilityAIAssistant
  } = (0, _use_kibana.useKibana)().services;
  const observabilityAIAssistantApi = observabilityAIAssistant.service.callApi;
  const {
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    networkMode: 'always',
    queryKey: [_constants.REACT_QUERY_KEYS.GET_KB_USER_INSTRUCTIONS],
    queryFn: async ({
      signal
    }) => {
      if (!signal) {
        throw new Error('Abort signal missing');
      }
      return observabilityAIAssistantApi(`GET /internal/observability_ai_assistant/kb/user_instructions`, {
        signal
      });
    }
  });
  return {
    userInstructions: data === null || data === void 0 ? void 0 : data.userInstructions,
    refetch,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}