"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootCauseAnalysisCollapsiblePanel = RootCauseAnalysisCollapsiblePanel;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _rca_panel = require("../rca_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RootCauseAnalysisCollapsiblePanel({
  title,
  content,
  color,
  isDisabled
}) {
  const htmlId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_rca_panel.RootCauseAnalysisPanel, {
    color: color
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `panel_${htmlId}`,
    buttonContent: title,
    isDisabled: isDisabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), content));
}