"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractIp = extractIp;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function extractIp(transport) {
  if (typeof transport !== 'string') {
    return null;
  }
  const matches = transport.match(/inet\[[^\/]*\/([^\/\]]+)\]/);
  if (matches) {
    return matches[1];
  }
  return transport;
}