"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReasonFound = ReasonFound;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _explanations = require("../explanations");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExplainWhyNoData = props => {
  const {
    reason
  } = props;
  const {
    property,
    data,
    context
  } = reason;
  switch (property) {
    case 'xpack.monitoring.collection.enabled':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainCollectionEnabled, props);
    case 'xpack.monitoring.collection.interval':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainCollectionInterval, props);
    case 'xpack.monitoring.exporters':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainExporters, props);
    case 'xpack.monitoring.exporters.cloud_enabled':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainExportersCloud, null);
    case 'xpack.monitoring.enabled':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainPluginEnabled, props);
    case 'custom':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, reason.message));
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.noData.reasons.explainWhyNoDataDescription",
        defaultMessage: "There is a {context} setting that has {property} set to {data}.",
        values: {
          context: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, context),
          property: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, property),
          data: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, data)
        }
      })));
  }
};
function ReasonFound(props) {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(ExplainWhyNoData, props));
}
ReasonFound.propTypes = {
  enabler: _propTypes.default.object.isRequired,
  reason: _propTypes.default.object.isRequired
};