"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBeatsInstructionsForEnablingMetricbeat = getBeatsInstructionsForEnablingMetricbeat;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _monospace = require("../components/monospace");
var _i18nReact = require("@kbn/i18n-react");
var _common_beats_instructions = require("./common_beats_instructions");
var _legacy_shims = require("../../../../legacy_shims");
var _common_instructions = require("../common_instructions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getBeatsInstructionsForEnablingMetricbeat(product, _meta, {
  esMonitoringUrl
}) {
  const metricbeatConfigUrl = _legacy_shims.Legacy.shims.docLinks.links.metricbeat.configure;
  const metricbeatInstallUrl = _legacy_shims.Legacy.shims.docLinks.links.metricbeat.install;
  const metricbeatStartUrl = _legacy_shims.Legacy.shims.docLinks.links.metricbeat.start;
  const httpEndpointUrl = _legacy_shims.Legacy.shims.docLinks.links.metricbeat.httpEndpoint;
  const beatType = product.beatType;
  const securitySetup = (0, _common_instructions.getSecurityStep)(metricbeatConfigUrl);
  const installMetricbeatStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.beatsInstructions.installMetricbeatTitle', {
      defaultMessage: 'Install Metricbeat on the same server as this {beatType}',
      values: {
        beatType: beatType || _common_beats_instructions.UNDETECTED_BEAT_TYPE
      }
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: metricbeatInstallUrl,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.beatsInstructions.installMetricbeatLinkText",
      defaultMessage: "Follow the instructions here."
    }))))
  };
  const enableMetricbeatModuleStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.beatsInstructions.enableMetricbeatModuleTitle', {
      defaultMessage: 'Enable and configure the Beat x-pack module in Metricbeat'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      language: "bash"
    }, "metricbeat modules enable beat-xpack"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.beatsInstructions.enableMetricbeatModuleDescription",
      defaultMessage: "By default the module will collect {beatType} monitoring metrics from http://localhost:5066. If the {beatType} instance being monitored has a different address, you must specify it via the {hosts} setting in the {file} file.",
      values: {
        hosts: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "hosts"),
        file: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "modules.d/beat-xpack.yml"),
        beatType: beatType || _common_beats_instructions.UNDETECTED_BEAT_TYPE
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "question",
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.metricbeatMigration.beatsInstructions.enableMetricbeatModuleHttpEnabledDirections",
        defaultMessage: "In order for Metricbeat to collect metrics from the running {beatType}, you need to {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: httpEndpointUrl,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.monitoring.metricbeatMigration.beatsInstructions.enableMetricbeatModuleHttpEnabledDirectionsLinkText",
            defaultMessage: "enable an HTTP endpoint for the {beatType} instance being monitored",
            values: {
              beatType
            }
          })),
          beatType: beatType || _common_beats_instructions.UNDETECTED_BEAT_TYPE
        }
      })))
    }), securitySetup)
  };
  const configureMetricbeatStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.beatsInstructions.configureMetricbeatTitle', {
      defaultMessage: 'Configure Metricbeat to send to the monitoring cluster'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.beatsInstructions.configureMetricbeatDescription",
      defaultMessage: "Make these changes in your {file}.",
      values: {
        file: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "metricbeat.yml")
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true
    }, `output.elasticsearch:
  hosts: [${esMonitoringUrl}] ## Monitoring cluster

  # Optional protocol and basic auth credentials.
  #protocol: "https"
  #username: "elastic"
  #password: "changeme"
`), securitySetup)
  };
  const startMetricbeatStep = {
    title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.beatsInstructions.startMetricbeatTitle', {
      defaultMessage: 'Start Metricbeat'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: metricbeatStartUrl,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.beatsInstructions.startMetricbeatLinkText",
      defaultMessage: "Follow the instructions here."
    }))))
  };
  const migrationStatusStep = (0, _common_instructions.getMigrationStatusStep)(product);
  return [installMetricbeatStep, enableMetricbeatModuleStep, configureMetricbeatStep, startMetricbeatStep, migrationStatusStep];
}