"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceTooltip = ({
  isCopiedFromPrimary,
  sourceTransportAddress,
  children
}) => {
  if (!sourceTransportAddress) {
    return children;
  }
  const tipText = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, sourceTransportAddress, /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.shardActivity.sourceTooltip",
    defaultMessage: "Copied from {copiedFrom} shard",
    values: {
      copiedFrom: isCopiedFromPrimary ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.elasticsearch.shardActivity.sourceTooltip.primarySourceText",
        defaultMessage: "primary"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.elasticsearch.shardActivity.sourceTooltip.replicaSourceText",
        defaultMessage: "replica"
      })
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tipText,
    position: "bottom"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, null, children));
};
exports.SourceTooltip = SourceTooltip;