"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TranslogProgress = exports.FilesProgress = exports.BytesProgress = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilesProgress = ({
  filesPercent,
  filesDone,
  filesTotal
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, filesPercent, /*#__PURE__*/_react.default.createElement("br", null), filesDone, " / ", filesTotal);
};
exports.FilesProgress = FilesProgress;
const BytesProgress = ({
  bytesPercent,
  bytesDone,
  bytesTotal
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, bytesPercent, /*#__PURE__*/_react.default.createElement("br", null), bytesDone, " / ", bytesTotal);
};
exports.BytesProgress = BytesProgress;
const TranslogProgress = ({
  hasTranslog,
  translogPercent,
  translogDone,
  translogTotal
}) => {
  return hasTranslog ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, translogPercent, /*#__PURE__*/_react.default.createElement("br", null), translogDone, " / ", translogTotal) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.shardActivity.progress.noTranslogProgressLabel",
    defaultMessage: "n/a"
  });
};
exports.TranslogProgress = TranslogProgress;