"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.consoleOutputLexerRules = exports.consoleOutputLanguageConfiguration = void 0;
var _shared = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const consoleOutputLanguageConfiguration = exports.consoleOutputLanguageConfiguration = {
  ..._shared.consoleSharedLanguageConfiguration
};
const consoleOutputLexerRules = exports.consoleOutputLexerRules = {
  ..._shared.consoleSharedLexerRules,
  tokenizer: {
    ..._shared.consoleSharedLexerRules.tokenizer,
    comments: [
    // Line comment indicated by #
    // Everything after the # character is matched, stopping right before the status code and status text at the end if they are present
    (0, _shared.matchTokensWithEOL)('comment.default', /# .+?(?=\s+\[\b1\d{2}(?: \w+)*\]$)/, 'root', 'status'), (0, _shared.matchTokensWithEOL)('comment.success', /# .+?(?=\s+\[\b2\d{2}(?: \w+)*\]$)/, 'root', 'status'), (0, _shared.matchTokensWithEOL)('comment.primary', /# .+?(?=\s+\[\b3\d{2}(?: \w+)*\]$)/, 'root', 'status'), (0, _shared.matchTokensWithEOL)('comment.warning', /# .+?(?=\s+\[\b4\d{2}(?: \w+)*\]$)/, 'root', 'status'), (0, _shared.matchTokensWithEOL)('comment.danger', /# .+?(?=\s+\[\b5\d{2}(?: \w+)*\]$)/, 'root', 'status'), ..._shared.consoleSharedLexerRules.tokenizer.comments],
    status: [
    // Status codes 100 – 199
    (0, _shared.matchTokensWithEOL)('status.default', /\[\b1\d{2}(?: \w+)*\]$/, 'root'),
    // Status codes 200 – 299
    (0, _shared.matchTokensWithEOL)('status.success', /\[\b2\d{2}(?: \w+)*\]$/, 'root'),
    // Status codes 300 – 399
    (0, _shared.matchTokensWithEOL)('status.primary', /\[\b3\d{2}(?: \w+)*\]$/, 'root'),
    // Status codes 400 – 499
    (0, _shared.matchTokensWithEOL)('status.warning', /\[\b4\d{2}(?: \w+)*\]$/, 'root'),
    // Status codes 500 – 599
    (0, _shared.matchTokensWithEOL)('status.danger', /\[\b5\d{2}(?: \w+)*\]$/, 'root')]
  }
};