"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSwimLaneDataFetcher = void 0;
var _rxjs = require("rxjs");
var _explorer_constants = require("../../application/explorer/explorer_constants");
var _constants = require("../../ui_actions/constants");
var _get_jobs_observable = require("../common/get_jobs_observable");
var _process_filters = require("../common/process_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FETCH_RESULTS_DEBOUNCE_MS = 500;
const initializeSwimLaneDataFetcher = (swimLaneApi, chartWidth$, dataLoading$, blockingError$, appliedTimeRange$, query$, filters$, refresh$, services) => {
  const {
    anomalyTimelineService,
    anomalyDetectorService
  } = services;
  const swimLaneData$ = new _rxjs.BehaviorSubject(undefined);
  const selectedJobs$ = (0, _get_jobs_observable.getJobsObservable)(swimLaneApi.jobIds, anomalyDetectorService, error => {
    blockingError$.next(error);
  }).pipe((0, _rxjs.shareReplay)(1));
  const swimLaneInput$ = (0, _rxjs.combineLatest)({
    jobIds: swimLaneApi.jobIds,
    swimlaneType: swimLaneApi.swimlaneType,
    viewBy: swimLaneApi.viewBy,
    perPage: swimLaneApi.perPage,
    fromPage: swimLaneApi.fromPage
  });
  const bucketInterval$ = (0, _rxjs.combineLatest)([selectedJobs$, chartWidth$.pipe((0, _rxjs.distinctUntilChanged)()), appliedTimeRange$]).pipe((0, _rxjs.skipWhile)(([jobs, width]) => {
    return !Array.isArray(jobs) || !width;
  }), (0, _rxjs.tap)(([,, timeRange]) => {
    anomalyTimelineService.setTimeRange(timeRange);
  }), (0, _rxjs.map)(([jobs, width]) => anomalyTimelineService.getSwimlaneBucketInterval(jobs, width)));
  const subscription = (0, _rxjs.combineLatest)([selectedJobs$, swimLaneInput$, query$, filters$, bucketInterval$, refresh$.pipe((0, _rxjs.startWith)(null))]).pipe((0, _rxjs.tap)(() => {
    dataLoading$.next(true);
  }), (0, _rxjs.debounceTime)(FETCH_RESULTS_DEBOUNCE_MS), (0, _rxjs.switchMap)(([explorerJobs, input, query, filters, bucketInterval]) => {
    if (!explorerJobs) {
      // couldn't load the list of jobs
      return (0, _rxjs.of)(undefined);
    }
    const {
      viewBy,
      swimlaneType,
      perPage,
      fromPage
    } = input;
    let appliedFilters;
    try {
      if (filters || query) {
        appliedFilters = (0, _process_filters.processFilters)(filters, query, _constants.CONTROLLED_BY_SWIM_LANE_FILTER);
      }
    } catch (e) {
      // handle query syntax errors
      blockingError$.next(e);
      return _rxjs.EMPTY;
    }
    return (0, _rxjs.from)(anomalyTimelineService.loadOverallData(explorerJobs, undefined, bucketInterval)).pipe((0, _rxjs.switchMap)(overallSwimlaneData => {
      const {
        earliest,
        latest
      } = overallSwimlaneData;
      if (overallSwimlaneData && swimlaneType === _explorer_constants.SWIMLANE_TYPE.VIEW_BY) {
        const swimLaneLimit = _explorer_constants.ANOMALY_SWIM_LANE_HARD_LIMIT;
        return (0, _rxjs.from)(anomalyTimelineService.loadViewBySwimlane([], {
          earliest,
          latest
        }, explorerJobs, viewBy, swimLaneLimit, perPage, fromPage, undefined, appliedFilters, bucketInterval)).pipe((0, _rxjs.map)(viewBySwimlaneData => {
          return {
            ...viewBySwimlaneData,
            earliest,
            latest
          };
        }));
      }
      return (0, _rxjs.of)(overallSwimlaneData);
    }), (0, _rxjs.catchError)(error => {
      blockingError$.next(error);
      return _rxjs.EMPTY;
    }));
  })).subscribe(data => {
    swimLaneApi.setInterval(data === null || data === void 0 ? void 0 : data.interval);
    dataLoading$.next(false);
    blockingError$.next(undefined);
    swimLaneData$.next(data);
  });
  return {
    swimLaneData$,
    onDestroy: () => {
      subscription.unsubscribe();
    }
  };
};
exports.initializeSwimLaneDataFetcher = initializeSwimLaneDataFetcher;