"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressIcon = ProgressIcon;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _progress_states = require("./progress_states");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Icon representing the progress of a running forecast.
 */

function ProgressIcon({
  state
}) {
  if (state === _progress_states.PROGRESS_STATES.WAITING) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    });
  } else if (state === _progress_states.PROGRESS_STATES.DONE) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      size: "m",
      color: "primary"
    });
  } else if (state === _progress_states.PROGRESS_STATES.ERROR) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      size: "m",
      color: "danger"
    });
  }
}
ProgressIcon.propTypes = {
  state: _propTypes.default.number
};