"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../contexts/kibana");
var _check_capabilities = require("../capabilities/check_capabilities");
var _toast_notification_service = require("../services/toast_notification_service");
var _locator = require("../../../common/constants/locator");
var _use_create_url = require("../contexts/kibana/use_create_url");
var _dst_utils = require("./calendars/dst_utils");
var _management = require("../management");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalyDetectionSettings = () => {
  const mlApi = (0, _kibana.useMlApi)();
  const [calendarsCount, setCalendarsCount] = (0, _react.useState)(0);
  const [calendarsDstCount, setCalendarsDstCount] = (0, _react.useState)(0);
  const [filterListsCount, setFilterListsCount] = (0, _react.useState)(0);
  const [canGetFilters, canCreateFilter, canGetCalendars, canCreateCalendar] = (0, _check_capabilities.usePermissionCheck)(['canGetFilters', 'canCreateFilter', 'canGetCalendars', 'canCreateCalendar']);
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const redirectToCalendarList = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.CALENDARS_MANAGE, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  const redirectToCalendarDstList = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.CALENDARS_DST_MANAGE, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  const redirectToNewCalendarPage = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.CALENDARS_NEW, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  const redirectToNewCalendarDstPage = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.CALENDARS_DST_NEW, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  const redirectToFilterLists = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.FILTER_LISTS_MANAGE, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  const redirectToNewFilterListPage = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.FILTER_LISTS_NEW, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  (0, _react.useEffect)(() => {
    loadSummaryStats();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  async function loadSummaryStats() {
    // Obtain the counts of calendars and filter lists.
    if (canGetCalendars === true) {
      try {
        const {
          calendarsDst,
          calendars
        } = (0, _dst_utils.separateCalendarsByType)(await mlApi.calendars());
        setCalendarsCount(calendars.length);
        setCalendarsDstCount(calendarsDst.length);
      } catch (e) {
        displayErrorToast(e, _i18n.i18n.translate('xpack.ml.settings.anomalyDetection.loadingCalendarsCountErrorMessage', {
          defaultMessage: 'An error occurred obtaining the count of calendars'
        }));
      }
    }
    if (canGetFilters === true) {
      try {
        const filterLists = await mlApi.filters.filtersStats();
        setFilterListsCount(filterLists.length);
      } catch (e) {
        displayErrorToast(e, _i18n.i18n.translate('xpack.ml.settings.anomalyDetection.loadingFilterListCountErrorMessage', {
          defaultMessage: 'An error occurred obtaining the count of filter lists'
        }));
      }
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.calendarsTitle",
    defaultMessage: "Calendars"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.calendarsText",
    defaultMessage: "Calendars contain a list of scheduled events for which you do not want to generate anomalies, such as planned system outages or public holidays."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, canGetCalendars && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      display: 'block'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.calendarsSummaryCount",
    defaultMessage: "You have {calendarsCountBadge} {calendarsCount, plural, one {calendar} other {calendars}}",
    values: {
      calendarsCountBadge: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, calendarsCount),
      calendarsCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlCalendarsMngButton",
    flush: "left",
    color: "primary",
    onClick: redirectToCalendarList,
    isDisabled: canGetCalendars === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.manageCalendarsLink",
    defaultMessage: "Manage"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlCalendarsCreateButton",
    flush: "left",
    color: "primary",
    onClick: redirectToNewCalendarPage,
    isDisabled: canCreateCalendar === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.createCalendarLink",
    defaultMessage: "Create"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.calendarsDstTitle",
    defaultMessage: "DST Calendars"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.calendarsDstText",
    defaultMessage: "DST calendars contain a list of scheduled events for which you do not want to generate anomalies, taking into account daylight saving time shifts that may cause events to occur one hour earlier or later."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, canGetCalendars && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      display: 'block'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.calendarsDstSummaryCount",
    defaultMessage: "You have {calendarsCountBadge} {calendarsDstCount, plural, one {calendar} other {calendars}}",
    values: {
      calendarsCountBadge: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, calendarsDstCount),
      calendarsDstCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlCalendarsDstMngButton",
    flush: "left",
    color: "primary",
    onClick: redirectToCalendarDstList,
    isDisabled: canGetCalendars === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.manageCalendarsDstLink",
    defaultMessage: "Manage"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlCalendarsDstCreateButton",
    flush: "left",
    color: "primary",
    onClick: redirectToNewCalendarDstPage,
    isDisabled: canCreateCalendar === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.createCalendarDstLink",
    defaultMessage: "Create"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.filterListsTitle",
    defaultMessage: "Filter Lists"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.filterListsText",
    defaultMessage: "Filter lists contain values that you can use to include or exclude events from the machine learning analysis."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, canGetFilters && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.filterListsSummaryCount",
    defaultMessage: "You have {filterListsCountBadge} {filterListsCount, plural, one {filter list} other {filter lists}}",
    values: {
      filterListsCountBadge: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, filterListsCount),
      filterListsCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlFilterListsMngButton",
    flush: "left",
    color: "primary",
    onClick: redirectToFilterLists,
    isDisabled: canGetFilters === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.manageFilterListsLink",
    defaultMessage: "Manage"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlFilterListsCreateButton",
    color: "primary",
    onClick: redirectToNewFilterListPage,
    isDisabled: canCreateFilter === false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.anomalyDetection.createFilterListsLink",
    defaultMessage: "Create"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)));
};
exports.AnomalyDetectionSettings = AnomalyDetectionSettings;