"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewPanelDefaultState = exports.default = exports.OverviewPage = exports.MLOverviewCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esqlUtils = require("@kbn/esql-utils");
var _upgrade = require("../components/upgrade");
var _help_menu = require("../components/help_menu");
var _kibana = require("../contexts/kibana");
var _use_create_url = require("../contexts/kibana/use_create_url");
var _locator = require("../../../common/constants/locator");
var _page_header = require("../components/page_header");
var _anomaly_detection_overview = require("./components/anomaly_detection_overview");
var _data_frame_analytics_overview = require("./components/data_frame_analytics_overview");
var _ml = require("../contexts/ml");
var _data_visualizer_grid = require("./data_visualizer_grid");
var _overview_ml_footer_item = require("./components/overview_ml_footer_item");
var _welcomeLight = _interopRequireDefault(require("./components/welcome--light.png"));
var _welcomeDark = _interopRequireDefault(require("./components/welcome--dark.png"));
var _check_capabilities = require("../capabilities/check_capabilities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overviewPanelDefaultState = exports.overviewPanelDefaultState = Object.freeze({
  nodes: true,
  adJobs: true,
  dfaJobs: true
});
const MLOverviewCard = ({
  layout,
  path,
  title,
  description,
  iconType,
  buttonLabel,
  cardDataTestSubj,
  buttonDataTestSubj,
  buttonType = 'empty'
}) => {
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const ButtonComponent = buttonType === 'empty' ? _eui.EuiButtonEmpty : _eui.EuiButton;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": cardDataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: layout,
    "data-test-subj": cardDataTestSubj,
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      iconType: iconType,
      onClick: () => navigateToPath(path),
      "aria-labelledby": "mlOverviewCardTitle"
    }),
    title: title,
    titleSize: "s",
    titleElement: "h3",
    id: "mlOverviewCardTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ButtonComponent, {
    flush: "left",
    target: "_self",
    onClick: () => navigateToPath(path),
    "data-test-subj": buttonDataTestSubj,
    "aria-label": buttonLabel
  }, buttonLabel)));
};
exports.MLOverviewCard = MLOverviewCard;
const OverviewPage = () => {
  var _user$user$username;
  const [user, setUser] = (0, _react.useState)();
  const {
    services: {
      docLinks,
      uiSettings,
      userProfile
    }
  } = (0, _kibana.useMlKibana)();
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const isDarkTheme = colorMode === 'DARK';
  const {
    isADEnabled,
    isDFAEnabled,
    isNLPEnabled
  } = (0, _ml.useEnabledFeatures)();
  const [canUseAiops] = (0, _check_capabilities.usePermissionCheck)(['canUseAiops']);
  const helpLink = docLinks.links.ml.guide;
  const trainedModelsDocLink = docLinks.links.ml.trainedModels;
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const navigateToTrainedModels = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)('', _locator.ML_PAGES.TRAINED_MODELS_MANAGE);
  const navigateToStackManagementMLOverview = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)('', 'overview');
  const isEsqlEnabled = (0, _react.useMemo)(() => uiSettings.get(_esqlUtils.ENABLE_ESQL), [uiSettings]);
  (0, _react.useEffect)(function loadUserName() {
    async function loadUser() {
      const currentUser = await userProfile.getCurrent();
      setUser(currentUser);
    }
    loadUser();
  }, [userProfile]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    alignItems: "center",
    restrictWidth: 1200,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, Boolean(user) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("h4", null, user ? _i18n.i18n.translate('xpack.ml.overview.welcomeBanner.header.greeting.customTitle', {
      defaultMessage: '👋 Hi {name}!',
      values: {
        name: (_user$user$username = user.user.username) !== null && _user$user$username !== void 0 ? _user$user$username : ''
      }
    }) : _i18n.i18n.translate('xpack.ml.overview.welcomeBanner.header.greeting.defaultTitle', {
      defaultMessage: '👋 Hi'
    })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.welcomeBanner.header.title",
      defaultMessage: "Welcome to the Machine Learning Hub"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, _i18n.i18n.translate('xpack.ml.overview.welcomeBanner.header.titleDescription', {
      defaultMessage: 'Analyze your data and generate models for its patterns of behavior.'
    })))),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      alt: _i18n.i18n.translate('xpack.ml.overview.welcomeBanner.header.imageAlt', {
        defaultMessage: 'Welcome to the Machine Learning Hub'
      }),
      src: isDarkTheme ? _welcomeDark.default : _welcomeLight.default,
      size: "l"
    })]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200
  }, /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, isADEnabled || isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.ml.overview.analyzeYourDataTitle', {
    defaultMessage: 'Analyze your data'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, isADEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlOverviewAnomalyDetectionCard"
  }, /*#__PURE__*/_react.default.createElement(_anomaly_detection_overview.AnomalyDetectionOverviewCard, null)) : null, isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlOverviewCardDataFrameAnalytics"
  }, /*#__PURE__*/_react.default.createElement(_data_frame_analytics_overview.DataFrameAnalyticsOverviewCard, null)) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null, canUseAiops ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.ml.overview.aiopsLabsTitle', {
    defaultMessage: 'AIOps Labs'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "m",
    columns: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    layout: "vertical",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      onClick: () => navigateToPath('/aiops/log_rate_analysis_index_select'),
      iconType: "logRateAnalysis",
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.logRateAnalysis.title', {
        defaultMessage: 'Log Rate Analysis'
      })
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logRateAnalysis.title",
      defaultMessage: "Log Rate Analysis"
    }),
    titleElement: "h3",
    titleSize: "s",
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logRateAnalysis.description",
      defaultMessage: "Advanced statistical methods to identify reasons for increases or decreases in log rates and displays the statistically significant data in a tabular format."
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      target: "_self",
      onClick: () => navigateToPath('/aiops/log_rate_analysis_index_select'),
      "data-test-subj": "mlOverviewCardLogRateAnalysisButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logRateAnalysis.startAnalysisButton",
      defaultMessage: "Start analysis"
    })),
    "data-test-subj": "mlOverviewCardLogRateAnalysis"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    layout: "vertical",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      iconType: "logPatternAnalysis",
      onClick: () => navigateToPath('/aiops/log_categorization_index_select'),
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.logPatternAnalysisTitle', {
        defaultMessage: 'Log Pattern Analysis'
      })
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logPatternAnalysisTitle",
      defaultMessage: "Log Pattern Analysis"
    }),
    titleElement: "h3",
    titleSize: "s",
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logPatternAnalysisDescription",
      defaultMessage: "Find patterns in unstructured log messages and make it easier to examine your data."
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      target: "_self",
      onClick: () => navigateToPath('/aiops/log_categorization_index_select'),
      "data-test-subj": "mlOverviewCardLogPatternAnalysisButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logPatternAnalysis.startAnalysisButton",
      defaultMessage: "Start analysis"
    })),
    "data-test-subj": "mlOverviewCardLogPatternAnalysis"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    layout: "vertical",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      iconType: "changePointDetection",
      onClick: () => navigateToPath('/aiops/change_point_detection_index_select'),
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.changePointDetection.title', {
        defaultMessage: 'Change Point Detection'
      })
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.changePointDetection.title",
      defaultMessage: "Change Point Detection"
    }),
    titleElement: "h3",
    titleSize: "s",
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.changePointDetection.description",
      defaultMessage: "Change point detection uses the change point aggregation to detect distribution changes, trend changes, and other statistically significant change points in a metric of your time series data."
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      target: "_self",
      onClick: () => navigateToPath('/aiops/change_point_detection_index_select'),
      "data-test-subj": "mlOverviewCardChangePointDetectionButton",
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.changePointDetection.startDetectionButton', {
        defaultMessage: 'Start detection'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.changePointDetection.startDetectionButton",
      defaultMessage: "Start detection"
    })),
    "data-test-subj": "mlOverviewCardChangePointDetection"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.ml.overview.visualizeYourDataTitle', {
    defaultMessage: 'Visualize your data'
  }))), /*#__PURE__*/_react.default.createElement(_data_visualizer_grid.DataVisualizerGrid, {
    isEsqlEnabled: isEsqlEnabled
  }))), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, isADEnabled || isNLPEnabled || isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_ml_footer_item.OverviewFooterItem, {
    icon: "dashboardApp",
    title: _i18n.i18n.translate('xpack.ml.overview.manageMlAssetsTitle', {
      defaultMessage: 'Manage ML Assets'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.manageMlAssetsDescription', {
      defaultMessage: 'Overview of your ML jobs, memory usage, and notifications.'
    }),
    docLink: helpLink,
    callToAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: navigateToStackManagementMLOverview
    }, _i18n.i18n.translate('xpack.ml.overview.goToManagmentLink', {
      defaultMessage: 'Go to Management'
    }))
  })) : null, isNLPEnabled || isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_ml_footer_item.OverviewFooterItem, {
    icon: "machineLearningApp",
    title: _i18n.i18n.translate('xpack.ml.overview.trainedModelsTitle', {
      defaultMessage: 'Trained Models'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.trainedModelsDescription', {
      defaultMessage: 'Add or manage Trained Models. See deployment stats or add a new deployment.'
    }),
    docLink: trainedModelsDocLink,
    callToAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: navigateToTrainedModels
    }, _i18n.i18n.translate('xpack.ml.overview.manageTrainedModelsLink', {
      defaultMessage: 'Manage Trained Models'
    }))
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_ml_footer_item.OverviewFooterItem, {
    icon: "documentation",
    title: _i18n.i18n.translate('xpack.ml.overview.browseDocumentationTitle', {
      defaultMessage: 'Browse documentation'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.browseDocumentationDescription', {
      defaultMessage: 'In-depth guides on Elastic Machine Learning.'
    }),
    docLink: helpLink,
    callToAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: helpLink,
      external: true,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.ml.overview.startReadingDocsLink', {
      defaultMessage: 'Start Reading'
    }))
  }))));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.OverviewPage = OverviewPage;
var _default = exports.default = OverviewPage;