"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTextExpansionInput = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _text_input = require("../text_input");
var _inference_base = require("../inference_base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryInput = ({
  inferrer
}) => {
  const questionText = (0, _useObservable.default)(inferrer.getQueryText$(), inferrer.getQueryText());
  const runningState = (0, _useObservable.default)(inferrer.getRunningState$(), inferrer.getRunningState());
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textExpansion.queryInput', {
      defaultMessage: 'Search query'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: questionText,
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING,
    fullWidth: true,
    onChange: e => {
      inferrer.setQueryText(e.target.value);
    }
  }));
};
const getTextExpansionInput = (inferrer, placeholder) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inferrer.getInputType() === _inference_base.INPUT_TYPE.TEXT ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_text_input.TextInput, {
  placeholder: placeholder,
  inferrer: inferrer
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(QueryInput, {
  inferrer: inferrer
}));
exports.getTextExpansionInput = getTextExpansionInput;