"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelStateColor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getModelStateColor = (state, canStartStopTrainedModels, nameOverrides) => {
  var _nameOverrides$downlo;
  switch (state) {
    case _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADED:
      return {
        color: 'success',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadedName', {
          defaultMessage: 'Ready to deploy'
        })
      };
    case _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADING:
      return {
        color: 'primary',
        name: (_nameOverrides$downlo = nameOverrides === null || nameOverrides === void 0 ? void 0 : nameOverrides.downloading) !== null && _nameOverrides$downlo !== void 0 ? _nameOverrides$downlo : _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadingName', {
          defaultMessage: 'Downloading'
        })
      };
    case _mlTrainedModelsUtils.MODEL_STATE.STARTED:
      return {
        color: '#E6F9F7',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.startedName', {
          defaultMessage: 'Deployed'
        }),
        get component() {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: this.color
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
            color: 'success',
            textSize: "xs",
            css: {
              display: 'inline'
            }
          }, this.name));
        }
      };
    case _mlTrainedModelsUtils.MODEL_STATE.STARTING:
      return {
        color: 'success',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.startingName', {
          defaultMessage: 'Deploying'
        }),
        get component() {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "xs",
            alignItems: "center"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "s"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "xs"
          }, this.name)));
        }
      };
    case _mlTrainedModelsUtils.MODEL_STATE.STOPPING:
      return {
        color: 'accent',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.stoppingName', {
          defaultMessage: 'Stopping'
        }),
        get component() {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "xs",
            alignItems: "center"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "s"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "xs"
          }, this.name)));
        }
      };
    case _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADED_IN_DIFFERENT_SPACE:
      return {
        color: 'warning',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadedInDifferentSpaceName', {
          defaultMessage: 'Downloaded in different space'
        }),
        get component() {
          const message = canStartStopTrainedModels ? _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadedInDifferentSpaceTooltip.canDeploy', {
            defaultMessage: 'The model is downloaded in a different space. Assign it to the current space to deploy it.'
          }) : _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadedInDifferentSpaceTooltip.cannotDeploy', {
            defaultMessage: 'The model is downloaded in a different space. If you have permission, assign it to the current space to review model details, or contact your administrator.'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            "aria-label": "Warning",
            size: "m",
            type: "warning",
            color: "warning",
            content: message
          });
        }
      };
    case _mlTrainedModelsUtils.MODEL_STATE.NOT_DOWNLOADED:
    default:
      return null;
  }
};
exports.getModelStateColor = getModelStateColor;