"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserConfirmationProvider = exports.StopModelDeploymentsConfirmDialog = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Confirmation is required when there are multiple model deployments
 * or associated pipelines.
 */
const StopModelDeploymentsConfirmDialog = ({
  model,
  onConfirm,
  onCancel
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [checkboxIdToSelectedMap, setCheckboxIdToSelectedMap] = (0, _react.useState)({});
  const trainedModelDeployments = (0, _react.useMemo)(() => {
    return model.deployment_ids
    // Filter out deployments that are used by inference services
    .filter(deploymentId => {
      if (!model.inference_apis) return true;
      return !model.inference_apis.some(inference => inference.inference_id === deploymentId);
    });
  }, [model]);
  const options = (0, _react.useMemo)(() => trainedModelDeployments.map(deploymentId => {
    return {
      id: deploymentId,
      label: deploymentId
    };
  }), [trainedModelDeployments]);
  const onChange = (0, _react.useCallback)(id => {
    setCheckboxIdToSelectedMap(prev => {
      return {
        ...prev,
        [id]: !prev[id]
      };
    });
  }, []);
  const selectedDeploymentIds = (0, _react.useMemo)(() => trainedModelDeployments.length > 1 ? Object.keys(checkboxIdToSelectedMap).filter(id => checkboxIdToSelectedMap[id]) : trainedModelDeployments, [trainedModelDeployments, checkboxIdToSelectedMap]);
  const deploymentPipelinesMap = (0, _react.useMemo)(() => {
    if (!(0, _mlIsPopulatedObject.isPopulatedObject)(model.pipelines)) return {};
    return Object.entries(model.pipelines).reduce((acc, [pipelineId, pipelineDef]) => {
      var _pipelineDef$processo;
      const deploymentIds = ((_pipelineDef$processo = pipelineDef === null || pipelineDef === void 0 ? void 0 : pipelineDef.processors) !== null && _pipelineDef$processo !== void 0 ? _pipelineDef$processo : []).map(v => {
        var _v$inference;
        return v === null || v === void 0 ? void 0 : (_v$inference = v.inference) === null || _v$inference === void 0 ? void 0 : _v$inference.model_id;
      }).filter(_mlIsDefined.isDefined);
      deploymentIds.forEach(dId => {
        if (acc[dId]) {
          acc[dId].push(pipelineId);
        } else {
          acc[dId] = [pipelineId];
        }
      });
      return acc;
    }, {});
  }, [model.pipelines]);
  const pipelineWarning = (0, _react.useMemo)(() => {
    if (trainedModelDeployments.length === 1 && (0, _mlIsPopulatedObject.isPopulatedObject)(model.pipelines)) {
      return Object.keys(model.pipelines);
    }
    return [...new Set(Object.entries(deploymentPipelinesMap).filter(([deploymentId]) => selectedDeploymentIds.includes(deploymentId)).flatMap(([, pipelineNames]) => pipelineNames))].sort();
  }, [trainedModelDeployments.length, model.pipelines, deploymentPipelinesMap, selectedDeploymentIds]);
  const inferenceServiceIDs = (0, _react.useMemo)(() => {
    var _model$inference_apis;
    return ((_model$inference_apis = model.inference_apis) !== null && _model$inference_apis !== void 0 ? _model$inference_apis : []).map(inference => inference.inference_id);
  }, [model]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.forceStopDialog.title', {
      defaultMessage: 'Stop {deploymentCount, plural, one {deployment} other {deployments}} of model {modelId}?',
      values: {
        modelId: model.model_id,
        deploymentCount: trainedModelDeployments.length
      }
    }),
    onCancel: onCancel,
    onConfirm: onConfirm.bind(null, selectedDeploymentIds),
    cancelButtonText: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.forceStopDialog.cancelText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.forceStopDialog.confirmText', {
      defaultMessage: 'Stop'
    }),
    buttonColor: "danger",
    confirmButtonDisabled: trainedModelDeployments.length > 1 && selectedDeploymentIds.length === 0
  }, trainedModelDeployments.length > 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    legend: {
      display: 'visible',
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.forceStopDialog.selectDeploymentsLegend",
        defaultMessage: "Select deployments to stop"
      })
    },
    options: options,
    idToSelectedMap: checkboxIdToSelectedMap,
    onChange: onChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  })) : null, pipelineWarning.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.forceStopDialog.pipelinesWarning",
      defaultMessage: "You won't be able to use these ingest pipelines until you restart the model:"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("ul", null, pipelineWarning.map(pipelineName => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: pipelineName
    }, pipelineName);
  }))))) : null, model.hasInferenceServices && inferenceServiceIDs.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.forceStopDialog.hasInferenceServicesWarning",
      defaultMessage: "The model is used by the _inference API"
    }),
    color: "warning",
    iconType: "warning"
  }) : null, inferenceServiceIDs.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.forceStopDialog.inferenceServicesWarning",
      defaultMessage: "The following {inferenceServicesCount, plural, one {deployment is} other {deployments are}} used by the _inference API and can not be stopped:",
      values: {
        inferenceServicesCount: inferenceServiceIDs.length
      }
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("ul", null, inferenceServiceIDs.map(deploymentId => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: deploymentId
    }, deploymentId);
  }))))) : null);
};
exports.StopModelDeploymentsConfirmDialog = StopModelDeploymentsConfirmDialog;
const getUserConfirmationProvider = (overlays, startServices) => async forceStopModel => {
  return new Promise(async (resolve, reject) => {
    try {
      const modalSession = overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(StopModelDeploymentsConfirmDialog, {
        model: forceStopModel,
        onCancel: () => {
          modalSession.close();
          reject();
        },
        onConfirm: deploymentIds => {
          modalSession.close();
          resolve(deploymentIds);
        }
      }), startServices));
    } catch (e) {
      reject();
    }
  });
};
exports.getUserConfirmationProvider = getUserConfirmationProvider;